#ifndef STARTMENU_H
#define STARTMENU_H

#include "Menus.h"


// button which changes the size of the maze
/** SizeButton Class
 * @brief Derived from Button. Allows the user to pick the size of Maze they wish to solve.
 * @brief Mazes can only be 12x12, 16x16 or 20x20.
 * @brief If enabled, the timer increases in length for larger mazes.
 */
class SizeButton : public Button {
    public:
    SizeButton() {
      x = 5;
      y = 16;
    }
    void virtual run() {
      if (mazeSize < 20)
        mazeSize += 4;
      printf("sizeButton pushed\n");
    }
    void virtual runBack() {
      if (mazeSize > 12)
        mazeSize -= 4;
      printf("sizeButton decreasing\n");
    }
};

// button which toggles the timer on or off
/** TimerButton Class
 * @brief Derived from Button. Toggles the timer on or off.
 * @brief If turned off, the timer will count up instead of down and there is no faliure state.
 * @brief I.e. the program will only end when the maze is finished.
 */
class TimerButton : public Button {
    public:
    TimerButton() {
      x = 5;
      y = 24;
    }
    void virtual run() {
      timerFlag = !timerFlag;
      printf("timerButton pushed\n");
    }
};

// button that triggers the main game loop
/** PlayButton Class
 * @brief Derived from Buttons. Triggers the main game loop.
 */
class PlayButton : public Button {
    public:
    PlayButton() {
      x = 5;
      y = 40;
    }
    void virtual run() {
      printf("PlayButton pushed\n");
      beginFlag = true;
    }
};


// the StartMenu is the menu for game setup and starting the game.
/** VictoryMenu Class
 * @brief Derived from Menu. Used to change the game's parameters of maze size and timer on or off.
 */
class StartMenu : public Menu {
    public:
    StartMenu(N5110* screenPtr) : Menu(screenPtr) {
        buttons[0] = new SizeButton;
        buttons[1] = new TimerButton;
        buttons[2] = new PlayButton;
        currentButton = buttons[0];
        numOfButtons = 3;
        buttonIndex = 0;
    }
    void virtual draw() {
      std::stringstream ssize;
      ssize << "Size: " << mazeSize;
      std::string someString;
      if (timerFlag)
        someString = "Timer: YES";
      else
        someString = "Timer: NO";
      lcd->printString("Game params:",10,1);
      lcd->printString(ssize.str().c_str(),10,2);
      lcd->printString(someString.c_str(),10,3);
      lcd->printString("Play",10,5);
    }
    /** Destructor
    */
    ~StartMenu() {
        delete buttons[0];
        delete buttons[1];
    }   
};

#endif // STARTMENU_H