#ifndef OPTIONSMENU_H
#define OPTIONSMENU_H

#include "Menus.h"

// Button class that can modify brightness

/** BrightnessButton Class
 * @brief Derived from Button. Can incremement or decremement the lcd brightness.
 * @brief Can only do so in incremements of 5% and can be volatile due to inputs firing twice.
 */
class BrightnessButton : public Button {
    public:
    N5110* lcd;
    BrightnessButton(N5110* screenPtr) : lcd(screenPtr) {
      x = 25;
      y = 16;
    }
    void virtual run() {
      if (brightnessVal < 0.97)
        brightnessVal += 0.05;
      lcd->setBrightness(brightnessVal);
      printf("Brightness increasing\n");
    }
    void virtual runBack() {
      if (brightnessVal > 0.03)
        brightnessVal -= 0.05; 
      lcd->setBrightness(brightnessVal);
      printf("Brightness decreasing\n");
    }
};

// Button class that can modify contrast
/** ContrastButton Class
 * @brief Derived from Button. Can incremement or decremement the lcd contrast.
 * @brief Can only do so in incremements of 5% and can be volatile due to inputs firing twice.
 */
class ContrastButton : public Button {
    public:
    N5110* lcd;
    ContrastButton(N5110* screenPtr) : lcd(screenPtr) {
      x = 25;
      y = 32;
    }
    void virtual run() {
      if (contrastVal < 0.97)
        contrastVal += 0.05;
      lcd->setContrast(contrastVal);
      printf("Contrast increasing\n");
    }
    void virtual runBack() {
      if (contrastVal > 0.03)
        contrastVal -= 0.05; 
      lcd->setContrast(contrastVal);
      printf("Contrast decreasing\n");
    }
};

// OptionsMenu lets the player modify the brightness and contrast
// of the lcd screen. can only increment in 5% steps.

/** OptionsMenu Class
 * @brief Derived from Menu. Displays the options to change brightness and contrast.
 */
class OptionsMenu : public Menu {
    public:
    OptionsMenu(N5110* screenPtr) : Menu(screenPtr) {
        buttons[0] = new BrightnessButton(lcd);
        buttons[1] = new ContrastButton(lcd);
        currentButton = buttons[0];
        numOfButtons = 2;
        buttonIndex = 0;
    }
    void virtual draw() {
      std::stringstream ssb;
      std::stringstream ssc;
      ssc << (contrastVal*100) << "%";
      ssb << (brightnessVal*100) << "%";
      lcd->printString("Options:",10,0);
      lcd->printString("Brightness:",10,1);
      lcd->printString(ssb.str().c_str(),30,2);
      lcd->printString("Contrast:",10,3);
      lcd->printString(ssc.str().c_str(),30,4);
    }
    /** Destructor
    */
    ~OptionsMenu() {
        delete buttons[0];
        delete buttons[1];
    }   
};

#endif // OPTIONSMENU_H