#ifndef MENUS_H
#define MENUS_H

#include <string>
#include <sstream>

#include "N5110.h"

/* because these classes are so short and so closely linked, they are declared
and defined in the same files for convenience and clarity */

/** Button Class
 * @brief An abstract class for all button's in the program
 * @brief The intent was to take advantage of polymorphism in C++ to cut out some large if-else blocks.
 * @brief There are two functions to overload, run() is always overloaded.
 * @brief runBack() is only overloaded for buttons attributed to increasing and decreasing variables, 
 * @brief for example buttons to modify the maze size or contrast/brightness.
 *
 * @brief Version 1.0
 * @author Thomas Caine
 * @date May 2019
 */
class Button {
    public:
    int x;
    int y;
    /** Button default constructor
    */
    Button() {
        x = y = 0;
    }
    /** virtual run function for polymorphism
    */
    void virtual run() {
        printf("Button\n");
    }
    /** virtual runBack function for polymorphism
    */
    void virtual runBack() {
        printf("Back functionality\n");
        // only overridden in functions that can be pressed backwards e.g. sliders
        // for contrast and brightness
    }
};

/** Menu Class
 * @brief An abstract class for all Menus's in the program
 * @brief Takes advantage of polymorphism. Draw() function is overriden in every inheriting Menu class.
 * @brief Score is used in the VictoryMenu and DefeatMenu classes.
 * @details Due to the similarity of Menu classes and their small size, I did not give them all header and source files.
 * @details Instead, classes are defined when they are declared in the same file and Buttons and Menus are grouped
 * @details into the same header files based on common functionality.
 *
 * @brief Version 1.0
 * @author Thomas Caine
 * @date May 2019
 */
class Menu {
    public:
    Button* buttons[3];
    int score; // used in the victory and defeat menus
    int numOfButtons;
    int buttonIndex;
    N5110* lcd;
    /** Constructor for the Menu base class.
     * @param lcd pointer - Passed to every menu object (derived classes super this constructor) so they can print to the lcd
     */
    Menu(N5110* screenPtr) : lcd(screenPtr) {
        numOfButtons = buttonIndex = 0;
    }
    /** Virtual draw function, overloaded by Menus to print unique stuff.
    */
    void virtual draw() {
        printf("This is a menu\n");
    }
};

// important flags used throughout the menus to interact with the game's settings
Menu *currentMenu;
Button *currentButton;
double contrastVal = 0.5;
double brightnessVal = 0.5;
int mazeSize = 12;
bool beginFlag = false;
bool restartFlag = false;
bool menuFlag = false;
bool timerFlag = true;


#endif // MENUS_H