#ifndef MAINMENU_H
#define MAINMENU_H

#include "StartMenu.h"
#include "OptionsMenu.h"
#include "MenuGraphics.h"
// StartButton takes you to the start menu screen.
/** StartButton Class
 * @brief Derived from Button. Takes you to the StartMenu screen where game params are set.
 */
class StartButton : public Button {
    public:
    N5110* lcd;
    StartButton(N5110* screenPtr) : lcd(screenPtr) {
        printf("StartButton constructor\n");
        x = 5;
        y = 16;
    }
    void virtual run() {
        printf("StartButton\n");
        delete currentMenu; // free the previous memory assigned to the pointer
        currentMenu = new StartMenu(lcd); // assign the new (next) menu to it
    }
};

// OptionsButton takes you to the game's options.
/** OptionsButton Class
 * @brief Derived from Button. Takes you to the options menu.
 */
class OptionsButton : public Button {
    public:
    N5110* lcd;
    OptionsButton(N5110* screenPtr) : lcd(screenPtr) {
        printf("OptionsButton constructor\n");
        x = 5;
        y = 24;
    }
    void virtual run() {
        printf("OptionsButton\n");
        delete currentMenu; // free the previous memory assigned to the pointer
        currentMenu = new OptionsMenu(lcd); // assign the new (next) menu to it
    }
};

// The MainMenu is the first menu displayed.
// It has only two buttons because I did not have time for a leaderboard
/** MainMenu Class
 * @brief Derived from Menu. MainMenu is the first menu displayed and serves as the start of the program loop.
 */
class MainMenu : public Menu {
    public:
    //Button* buttons[2];
    MainMenu(N5110* screenPtr) : Menu(screenPtr) {
        buttons[0] = new StartButton(lcd);
        buttons[1] = new OptionsButton(lcd);
        currentButton = buttons[0];
        numOfButtons = 2;
        buttonIndex = 0;
    }
    void virtual draw() {
      lcd->drawSprite(20,1,12,44,(int *)menuGraphic);
      lcd->printString("Start",10,2);
      lcd->printString("Options",10,3);
    }
    /** Destructor
    */
    ~MainMenu() {
        delete buttons[0];
        delete buttons[1];
    }   
};

#endif // MAINMENU_H