#ifndef DEFEATMENU_H
#define DEFEATMENU_H

#include "VictoryMenu.h"

/* screen that displays when the player runs out of time in the maze
reuses the yes and no buttons so VictoryMenu is included */

/** VictoryMenu Class
 * @brief Derived from Menu. Displayed when the timer expires.
 */
class DefeatMenu : public Menu {
    public:
    DefeatMenu(N5110* screenPtr) : Menu(screenPtr) {
        buttons[0] = new YesButton;
        buttons[1] = new NoButton;
        currentButton = buttons[0];
        numOfButtons = 2;
        buttonIndex = 0;
    }
    void virtual draw() {
      std::stringstream sscore;
      sscore << "Score: " << score;
      lcd->printString("GAME OVER",10,1);
      lcd->printString(sscore.str().c_str(),10,2);
      lcd->printString("Play again?",10,3);
      lcd->printString("Yes      No",10,4);
    }
    /** Destructor
    */
    ~DefeatMenu() {
        delete buttons[0];
        delete buttons[1];
    }   
};

#endif // DEFEATMENU_H