#ifndef MAZE_H
#define MAZE_H

/** Maze Class
 * @brief This class is responsible for selecting, storing and manipulating the current maze.
 * @brief It also makes it easier to pass the 2D array of the matrix to other classes
 * @brief that need access to the maze's data, such as Drawer and Player.
 *
 * @brief All pre-defined matrices are 20x20 in size, even if their actual size is smaller 
 * @brief The extra space is padded with 1's, this is to make the function calling significantly
 * @brief simpler.
 *
 * @brief Version 1.0
 * @author Thomas Caine
 * @date May 2019
 */
class Maze {

    public:
        /** Create a Maze object to manage the maze matrix.
         */
        Maze();
        /** Fill the maze matrix with a specific value in every cell
         * @param val - the value to put in every cell
         * Used to reset the maze by setting it to all 1's (solid cells)
         * every time the game restarts.
         */
        void fillMaze(int val);
        /** Copies the contents of a maze to the object's version
         * @param maze - a predefined maze to be copied into the object's matrix field.
         * @details the mazes passed to this function are all pre-defined in MazeMatrices.h
         */
        void copyMaze(int maze[20][20]);
        /** Randomly selects a maze of a specified size
         * @param size - can be 12, 16 or 20, all mazes are square.
         * @details this function will randomly select one from 3 pre-defined mazes.
         */
        void selectMaze(int size);
    
    public:
        int mazeMatrix[20][20];
        int startX;
        int startY;
        int timeToFinish;
        
};



#endif  // MAZE_H