#include <ctime> // for seeding the random number generator
#include <cstdlib> // for rand()
#include "Maze.h"
#include "mbed.h"
#include "MazeMatrices.h"

// Constructor generates a maze of solid cells
Maze::Maze() {
    fillMaze(1);
}

// Fills the maze with a specific value
void Maze::fillMaze(int val) {
    for (int i = 0; i < 20; i++) {
        for (int j = 0; j < 20; j++) {
            mazeMatrix[i][j] = val;
        }
    }
}

// cycles through each index to copy a maze to the
// the maze as stored in the Maze object
void Maze::copyMaze(int maze[20][20]) {
    fillMaze(1);
    for (int i = 0; i < 20; i++) {
        for (int j = 0; j < 20; j++) {
            mazeMatrix[i][j] = maze[i][j];
        }
    }
}

// randomly selects between 3 variants for one of the 3 available sizes
// there are 9 mazes in total, the size is user specified but which variant is random
void Maze::selectMaze(int size) {
    printf("selecting maze size\n");
    srand(time(0));
    int variant = rand() % 3 + 1;
    printf("maze %i was randomly chosen\n", variant);
    switch (size) {
        case 12:
            printf("mazeSize is 12\n");
            switch (variant) {
            case 1:
                copyMaze(maze12one);
                startX = 10;
                startY = 10;
                break;
            case 2:
                copyMaze(maze12two);
                startX = 5;
                startY = 10;
                break;
            case 3:
                copyMaze(maze12three);
                startX = 1;
                startY = 10;
                break;
            }
            timeToFinish = 120;
            break;
        case 16:
            printf("mazeSize is 16\n");
            switch (variant) {
            case 1:
                copyMaze(maze16one);
                startX = 7;
                startY = 14;
                break;
            case 2:
                copyMaze(maze16two);
                startX = 4;
                startY = 9;
                break;
            case 3:
                copyMaze(maze16three);
                startX = 12;
                startY = 14;
                break;
            }
            timeToFinish = 180;
            break;
        case 20:
            printf("mazeSize is 20\n");
            switch (variant) {
            case 1:
                copyMaze(maze20one);
                startX = 16;
                startY = 18;
                break;
            case 2:
                copyMaze(maze20one);
                startX = 10;
                startY = 10;
                break;
            case 3:
                copyMaze(maze20one);
                startX = 3;
                startY = 18;
                break;
            }
            timeToFinish = 240;
            break;
    }
}
