#ifndef DRAWER_H
#define DRAWER_H

#include "Player.h"
#include "N5110.h"
/** Drawer Class
 * @brief A class responsible for searching the maze matrix relative to the player's location
 * @brief and drawing the correct graphics to the LCD accordingly.
 * @brief can draw cells up to a distance of 4 in front of the player
 * @brief (not including the cell they are currently standing in).
 *
 * @brief Version 1.0
 * @author Thomas Caine
 * @date May 2019
 */
class Drawer {
    
    public:
        /** Create a Drawer object capable of printing to the lcd
         * @param player - pointer to a player object. Player's direction and position is needed
         * @param screenPtr - pointer to the LCD object. Important for the lcd object to be shared so it's a pointer.
         */
        Drawer(Player* player, N5110* screenPtr);
        
        /** Draw the first branch.
         *
         *  This corresponds to the line of 3 cells in front of the player,
         *  beginning from the cell immediately to their _left_.
         * @param location - vector representing the cell to begin branch search from
         */
        void drawBranch1(Vector2Di loc);
        /** Draw the second branch.
         *
         *  This corresponds to the line of 3 cells in front of the player,
         *  beginning from the cell immediately to their _right_.
         * @param location - vector representing the cell to begin branch search from
         */
        void drawBranch2(Vector2Di loc);
        /** Draw the third branch.
         *
         *  This corresponds to the line of 3 cells in front of the player,
         *  beginning from the cell forward one and left one.
         * @param location - vector representing the cell to begin branch search from
         */
        void drawBranch3(Vector2Di loc);
        /** Draw the fourth branch.
         *
         *  This corresponds to the line of 3 cells in front of the player,
         *  beginning from the cell forward one and right one.
         * @param location - vector representing the cell to begin branch search from
         */
        void drawBranch4(Vector2Di loc);
        /** Draw the fifth branch.
         *
         *  This corresponds to the line of 3 cells in front of the player,
         *  beginning from the cell forward two and left one.
         * @param location - vector representing the cell to begin branch search from
         */
        void drawBranch5(Vector2Di loc);
        /** Draw the fifth branch.
         *
         *  This corresponds to the line of 3 cells in front of the player,
         *  beginning from the cell forward two and right one.
         */
        void drawBranch6(Vector2Di loc);
        /** 
         * @brief Draw the player's current view to the screen buffer.
         *  
         * @details drawScreen() will walk the cells in front of the player, checking
         * @details which cells are empty or solid. When it finds an empty cell either in
         * @details front, to the left or to the right of the current cell, it will draw graphics
         * @details and/or call the drawBranch# functions accordingly.
         */
        void drawScreen();
        
        // references to the player and lcd objects
        Player* player;
        N5110* lcd;
    
    
    
};

#endif // DRAWER_H