#include "Drawer.h"
#include "GraphicMatrices.h"

// constructor simply assigns the passed pointers to the
// class' internal fields for storage
Drawer::Drawer(Player* playerPtr, N5110* screenPtr) {
    player = playerPtr;
    lcd = screenPtr;
}

void Drawer::drawBranch1(Vector2Di loc) {
    Vector2Di peekDirection = player->direction;
    peekDirection.rotateVector(-PI/2); // rotate vector left
    loc.addVector(peekDirection);      // then move forward one
    
    lcd->drawSprite(0,3,42,21,(int *)greenBranchG);
    if (player->checkLocation(loc, 0, 0)) {
        //if the square in front is open
        lcd->drawSprite(0,9,30,21,(int *)sideSquare1G);    
        loc.addVector(player->direction); // move forward
    }
    else if (player->checkLocation(loc, 0, 2)) {
        // if the square in front is the exit
        lcd->drawSprite(0,9,30,21,(int *)sideSquare1G);   
        lcd->drawSprite(0,8,32,21,(int *)exit2); // draw the exit graphic for this position
        return;
    }
    else {
        return;
    }
    if (player->checkLocation(loc, -PI/2, 0))
        lcd->drawSprite(0,12,24,7,(int *)sideBranch1G);
    if (player->checkLocation(loc, 0, 0))
        lcd->drawSprite(10,13,22,11,(int *)sideSquare2G);
    else if (player->checkLocation(loc, 0, 2)) {
        lcd->drawSprite(10,13,22,11,(int *)sideSquare2G);
        lcd->drawSprite(15,15,18,6,(int *)exit6);
    }
}

void Drawer::drawBranch2(Vector2Di loc) {
    Vector2Di peekDirection = player->direction;
    peekDirection.rotateVector(PI/2);
    loc.addVector(peekDirection);    
    lcd->drawSprite(63,3,42,21,(int *)greenBranchG);
    if (player->checkLocation(loc, 0, 0)) {
        lcd->drawSprite(63,9,30,21,(int *)sideSquare6G);    
        loc.addVector(player->direction); 
    }
    else if (player->checkLocation(loc, 0, 2)) {
        //lcd->drawSprite(63,9,30,21,(int *)sideSquare6G);   
        lcd->drawSprite(63,8,32,21,(int *)exit2);
        return;
    }
    else {
        return;
    }
    if (player->checkLocation(loc, PI/2, 0))
        lcd->drawSprite(77,12,24,7,(int *)sideBranch1G);
    if (player->checkLocation(loc, 0, 0))
        lcd->drawSprite(63,13,22,11,(int *)sideSquare7G);
    else if (player->checkLocation(loc, 0, 2)) {
        lcd->drawSprite(63,13,22,11,(int *)sideSquare7G);
        lcd->drawSprite(63,15,18,6,(int *)exit5);
    }
}


void Drawer::drawBranch3(Vector2Di loc) {
    Vector2Di peekDirection = player->direction;
    peekDirection.rotateVector(-PI/2);
    loc.addVector(peekDirection);    
    lcd->drawSprite(22,12,24,8,(int *)orangeBranchG);
    if (player->checkLocation(loc, 0, 0)) {
        lcd->drawSprite(22,17,14,8,(int *)sideSquare3G);    
        loc.addVector(player->direction); 
    }
    else if (player->checkLocation(loc, 0, 2)) {
        //lcd->drawSprite(22,17,14,8,(int *)sideSquare3G);   
        lcd->drawSprite(22,15,18,8,(int *)exit4);
        return;
    }
    else {
        return;
    }
    if (player->checkLocation(loc, 0, 0)) {
        lcd->drawSprite(28,19,10,2,(int *)sideSquare4G);    
    }
    else {
        return;
    }
}
void Drawer::drawBranch4(Vector2Di loc) {
    Vector2Di peekDirection = player->direction;
    peekDirection.rotateVector(PI/2);
    loc.addVector(peekDirection);    
    lcd->drawSprite(54,12,24,8,(int *)orangeBranchG);
    if (player->checkLocation(loc, 0, 0)) {
        lcd->drawSprite(54,17,14,8,(int *)sideSquare8G);    
        loc.addVector(player->direction); 
    }
    else if (player->checkLocation(loc, 0, 2)) {
        //lcd->drawSprite(54,17,14,8,(int *)sideSquare8G);    
        lcd->drawSprite(54,15,18,8,(int *)exit4);
        return;
    }
    else {
        return;
    }
    if (player->checkLocation(loc, 0, 0)) {
        lcd->drawSprite(54,19,10,2,(int *)sideSquare4G);
    }
    else {
        return;
    }
}
void Drawer::drawBranch5(Vector2Di loc) {
    Vector2Di peekDirection = player->direction;
    peekDirection.rotateVector(-PI/2);
    loc.addVector(peekDirection);    
    lcd->drawSprite(31,18,12,5,(int *)blueBranchG);
    if (player->checkLocation(loc, 0, 0)) {
        lcd->drawSprite(31,20,8,5,(int *)sideSquare5G);    
    }
    else if (player->checkLocation(loc, 0, 2)) {
        //lcd->drawSprite(54,17,14,8,(int *)sideSquare5G);    
        lcd->drawSprite(31,20,8,5,(int *)exit8);
        return;
    }
    else {
        return;
    }
}
void Drawer::drawBranch6(Vector2Di loc) {
    Vector2Di peekDirection = player->direction;
    peekDirection.rotateVector(PI/2);
    loc.addVector(peekDirection);    
    lcd->drawSprite(48,18,12,5,(int *)blueBranchG);
    if (player->checkLocation(loc, 0, 0)) {
        lcd->drawSprite(48,20,8,5,(int *)sideSquare9G);    
    }
    else if (player->checkLocation(loc, 0, 2)) {
        //lcd->drawSprite(48,20,8,5,(int *)sideSquare9G);   
        lcd->drawSprite(48,20,8,5,(int *)exit8);
        return;
    }
    else {
        return;
    }
}

void Drawer::drawScreen() {
    Vector2Di ghostLocation = player->pos;
    // phase 1
    lcd->drawSprite(18,0,48,48,(int *)greenSquareG);
    if (player->checkLocation(ghostLocation, -PI/2, 0)) // if the left square is empty
        drawBranch1(ghostLocation);
    if (player->checkLocation(ghostLocation, PI/2, 0)) // left/right are reversed
        drawBranch2(ghostLocation);
        
    if (player->checkLocation(ghostLocation, 0, 0)) { // if the front square is empty
        ghostLocation.addVector(player->direction); // move forward
    }
    else if (player->checkLocation(ghostLocation, 0, 2)) {
        lcd->drawSprite(22,4,40,40,(int *)orangeSquareG);
        lcd->drawSprite(26,8,32,32,(int *)exit1); // if front square is exit
        return;
    }
    else {
        return; // drawing is complete
    }
    // phase 2
    lcd->drawSprite(22,4,40,40,(int *)orangeSquareG);
    if (player->checkLocation(ghostLocation, -PI/2, 0)) // if the left square is empty
        drawBranch3(ghostLocation);
    if (player->checkLocation(ghostLocation, PI/2, 0))
        drawBranch4(ghostLocation);
    if (player->checkLocation(ghostLocation,0, 0)) { // if the front square is empty
        ghostLocation.addVector(player->direction); // move forward
    }
    else if (player->checkLocation(ghostLocation, 0, 2)) {
        lcd->drawSprite(31,13,22,22,(int *)blueSquareG);
        lcd->drawSprite(33,15,18,18,(int *)exit3); // if front square is exit
        return;
    }
    else {
        return; // drawing is complete
    }
    // phase 3
    lcd->drawSprite(31,13,22,22,(int *)blueSquareG);
    if (player->checkLocation(ghostLocation, -PI/2, 0)) // if the left square is empty
        drawBranch5(ghostLocation);
    if (player->checkLocation(ghostLocation, PI/2, 0))
        drawBranch6(ghostLocation);
        
    if (player->checkLocation(ghostLocation,0, 0)) { // if the front square is empty
        ghostLocation.addVector(player->direction); // move forward
    }
    else if (player->checkLocation(ghostLocation, 0, 2)) {
        lcd->drawSprite(37,19,10,10,(int *)yellowSquareG);
        lcd->drawSprite(38,20,8,8,(int *)exit7); // if front square is exit
        return;
    }
    else {
        return; // drawing is complete
    }
    // phase 4
    lcd->drawSprite(37,19,10,10,(int *)yellowSquareG);
    if (player->checkLocation(ghostLocation, -PI/2, 0)) // if the left square is empty
        lcd->drawSprite(37,21,6,2,(int *)yellowBranchG);
    if (player->checkLocation(ghostLocation, PI/2, 0))
        lcd->drawSprite(45,21,6,2,(int *)yellowBranchG);
        
    if (player->checkLocation(ghostLocation,0, 0)) { // if the front square is empty
        ghostLocation.addVector(player->direction); // move forward
    }
    else {
        return; // drawing is complete
    }
    // phase 5
    lcd->drawSprite(40,22,4,4,(int *)purpleSquareG);
}