#include "SceneCreator.h"
#include "ScenePaths.h"

//Timer for dynamic wait times to reduce notice-able lagging between scenes
Timer dynatime;

DigitalOut led(LED_BLUE);
Serial pc(USBTX,USBRX);

//Constructor
SceneCreator::SceneCreator(PinName Button) {
    this->set_buttonPin(Button);
    dead = false;   
}

//Destructor
SceneCreator::~SceneCreator() {
   this->deletebutton();
}

//Primary Function
void SceneCreator::Scenesp(Bitmap &lcd, CaMove &CM,short int spl,short int spx,short int spy, Direction spd, int rng,WDplayer &wav) {
    this->setup(lcd,CM,spl,spx,spy,spd,wav);
    while(!dead && CM.in_screen()) {  //Main Loop exit if charater dead or leaves screen
        dynatime.start();
        lcd.clear();
        wav.ISRpreload();
        lcd.renderBMP(SCN[spl],0,0);                 //Map Made
        this->Core_1(lcd, CM,spl,rng,p);             //Pre - Events
        this->update_charaters(lcd,CM,spl,wav);
        this->Core_2(lcd, CM,spl,rng,p,wav);         //Pos - Events
        if (CM.is_caught()) {
            dead = true;
        }
        lcd.refresh();
        this->dynamic_wait();
    };
    wav.ISRreset();               //Clear Scene data
    CM.delete_regions();
};


//Internal Functions for Scenesp

void SceneCreator::setup(Bitmap &lcd, CaMove &CM,short int spl,short int spx,short int spy, Direction spd, WDplayer &wav) {
    //Setting up WDplayer, CaMove and Scene interative regions
    wav.ISRset();
    CM.init(spx,spy,spd);
    CM.AIinit(spl);
    lcd.normalMode();
    this->set_sreg(CM,spl);
    this->reset_variables();
    //Array to allow Pos Events to disable or enable Pre Events (Resetting)
    p[0] = true;
    p[1] = true;
    p[2] = true;
    p[3] = true;
    p[4] = true;
}


//CORE_1 (Pre EVENTS) 
void SceneCreator::Core_1(Bitmap &lcd, CaMove &CM,short int spl,int rng,bool p[5]) {
    if (p[0]) {
            this->pre_func0(spl,lcd,CM,rng);
        }
        if (p[1]) {
            this->pre_func1(spl,lcd,CM,rng);
        }
        if (p[2]) {
            this->pre_func2(spl,lcd,CM,rng);
        }
        if (p[3]) {
            this->pre_func3(spl,lcd,CM,rng);
        }
        if (p[4]) {
            this->pre_func4(spl,lcd,CM,rng);
        }
}

//CORE_2 (Pos EVENTs)
void SceneCreator::Core_2(Bitmap &lcd, CaMove &CM,short int spl,int rng,bool (&p)[5],WDplayer &wav) {
    switch(CM.get_treg()) {     //Checks which region triggered
            case 0:
                this->task_completed(p[0] ,lcd ,wav);
                this->pos_func0(spl,lcd,CM,rng,wav);
                break;
            case 1:
                this->task_completed(p[1] ,lcd ,wav);
                this->pos_func1(spl,lcd,CM,rng);
            break;
            case 2:
                this->task_completed(p[2] ,lcd ,wav);
                this->pos_func2(spl,lcd,CM,rng);
            break;
            case 3:
                this->task_completed(p[3] ,lcd ,wav);
                this->pos_func3(spl,lcd,CM,rng);
            break;
            case 4:
                this->task_completed(p[4] ,lcd ,wav);
                this->pos_func4(spl,lcd,CM,rng);
            break;     
        };
        wav.ISRresume();
}

void SceneCreator::update_charaters(Bitmap &lcd, CaMove &CM,short int spl, WDplayer &wav) {
    //Charater and Chaser Model Update
    CM.move(lcd);
    CM.chase(lcd,spl);
    wav.ISRpreload();
}

void SceneCreator::dynamic_wait() {
   dynatime.stop();
        float waittime = 0.15f - dynatime.read();
        if (waittime > 0.00000f) {
            wait(waittime);
        }
        dynatime.reset();
        //Will aim for 7 frames per second if too heavy of performance impacting frame rate will drop 
}

//Aiding Functions - used in Core 2 

void SceneCreator::task_completed(bool &uno, Bitmap &lcd, WDplayer &wav) {
    wav.ISRpause();
    if(uno) {
        uno *= false;
        this->flash(lcd);
    }
}


//settings
//All below Functions Check which scene is operating and then fetches the required Function from SceneFunctions
//They all are they same...
void SceneCreator::set_sreg(CaMove &CM,int sce) {
    switch(sce) {
        case 0:
        this->set_scene0(CM);
        break;
        case 1:
        this->set_scene1(CM);
        break;
        case 2:
        this->set_scene2(CM);
        break;
        case 3:
        this->set_scene3(CM);
        break;
        case 4:
        this->set_scene4(CM);
        break;
    }
}

//pre-func
void SceneCreator::pre_func0(int sce,Bitmap &lcd,CaMove &CM,int rng) {
    switch(sce) {
        case 0:
        this->obj0_scene0(lcd);
        break;
        case 1:
        this->obj0_scene1(lcd);
        break;
        case 2:
        this->obj0_scene2(lcd);
        break;
        case 3:
        this->obj0_scene3(lcd);
        break;
        case 4:
        break;
    }
}

void SceneCreator::pre_func1(int sce,Bitmap &lcd,CaMove &CM,int rng) {
    switch(sce) {
        case 0:
        break;
        case 1:
        this->obj1_scene1(lcd);
        break;
        case 2:
        this->obj1_scene2(lcd,rng);
        break;
        case 3:
        this->obj1_scene3(lcd);
        break;
        case 4:
        this->obj1_scene4(lcd);
        break;  
    }
}

void SceneCreator::pre_func2(int sce,Bitmap &lcd,CaMove &CM,int rng) {
    switch(sce) {
        case 0:
        break;
        case 1:
        break;
        case 2:
        break;
        case 3:
        break;
        case 4:
        this->obj2_scene4(lcd,rng);
        break;
    }
}

void SceneCreator::pre_func3(int sce,Bitmap &lcd,CaMove &CM,int rng) {
    switch(sce) {
        case 0:
        break;
        case 1:
        break;
        case 2:
        break;
        case 3:
        this->obj3_scene3(lcd);
        break;
        case 4:
        this->obj3_scene4(lcd);
        break;
    }
}

void SceneCreator::pre_func4(int sce,Bitmap &lcd,CaMove &CM,int rng) {
    switch(sce) {
        case 0:
        break;
        case 1:
        break;
        case 2:
        break;
        case 3:
        this->obj4_scene3(lcd);
        break;
        case 4:
        break;
    }
}

//pos func

void SceneCreator::pos_func0(int sce,Bitmap &lcd,CaMove &CM,int rng,WDplayer &wav) {
    switch(sce) {
        case 0:
        this->event0_scene0(lcd);
        break;
        case 1:
        this->event0_scene1(lcd);
        break;
        case 2:
        this->event0_scene2(lcd,CM,wav);
        break;
        case 3:
        this->event0_scene3(lcd);
        break;
        case 4:
        this->event0_scene4(lcd,CM,wav);
        break;
    }
}

void SceneCreator::pos_func1(int sce,Bitmap &lcd,CaMove &CM,int rng) {
    switch(sce) {
        case 0:
        this->event1_scene0(lcd);
        break;
        case 1:
        this->event1_scene1(lcd,CM);
        break;
        case 2:
        break;
        case 3:
        this->event1_scene3(lcd);
        break;
        case 4:
        break;
    }
}

void SceneCreator::pos_func2(int sce,Bitmap &lcd,CaMove &CM,int rng) {
    switch(sce) {
        case 0:
        break;
        case 1:
        break;
        case 2:
        break;
        case 3:
        this->event2_scene3(lcd);
        break;
        case 4:
        break;
    }
}


void SceneCreator::pos_func3(int sce,Bitmap &lcd,CaMove &CM,int rng) {
    switch(sce) {
        case 0:
        break;
        case 1:
        break;
        case 2:
        break;
        case 3:
        this->event3_scene3(lcd,CM);
        break;
        case 4:
        break;
    }
}

void SceneCreator::pos_func4(int sce,Bitmap &lcd,CaMove &CM,int rng) {
    switch(sce) {
        case 0:
        break;
        case 1:
        break;
        case 2:
        break;
        case 3:
        break;
        case 4:
        break;
    }
}

//Accessors and Mutators and other Small Functions

bool SceneCreator::get_dead() {
    return dead;
}

void SceneCreator::set_dead(bool opt) {
    dead = opt;
}


void SceneCreator::flashy(Bitmap &lcd) {
    this->flash(lcd);
}
