#include "Bitmap.h"

//Total New Process time = 0.04 Seconds (still a bit long)
//Image data is Stored in DWORDS (32-bits) not Bytes (8-bits)
Bitmap::Bitmap(PinName const scePin,
               PinName const rstPin,
               PinName const dcPin,
               PinName const mosiPin,
               PinName const sclkPin,
               PinName const ledPin)
        :
        N5110(scePin, rstPin, dcPin, mosiPin, sclkPin, ledPin) 
{};

void Bitmap::renderBMP(const char *path, unsigned int const x, unsigned int const y) {
    FILE *bmp = fopen(path,"r");
    if (bmp == NULL) {
        std::cerr << "failure " << path << std::endl;
    }
    unsigned char *buffer = (unsigned char*)std::malloc(4 * sizeof(unsigned char));
    this->readDIB(bmp);  //Reading DIB header
    unsigned short int dcount = (width / 32) + 1;   //Counting DWORDS required per Row of Image
    fseek(bmp,offbits,SEEK_SET);
    std::bitset<32> bits;
    offbits = 0;
    row = 0; 
    colomn = 0;
    for (unsigned int dwcount = 1; dwcount < ((dcount*height) + 1); dwcount++) {
        this->swapEndian(bmp, buffer, bits); //Correcing Machine Endiness
        if (dwcount % dcount == 0) {
            this->halfLoop(x,y,bits);
        } else {
            this->fullLoop(x,y,bits);
        }
    }
    std::fclose(bmp);
    free(buffer);
}

void Bitmap::readDIB(FILE *bmp) {
    std::fseek(bmp,10,SEEK_SET);
    std::fread(&offbits,4,1,bmp);  //Bytes to skip to get to data block
    std::fseek(bmp,18,SEEK_SET);
    std::fread(&width,4,1,bmp);    //Width of Image
    std::fseek(bmp,22,SEEK_SET);
    std::fread(&height,4,1,bmp);   //Height of image
}

void Bitmap::swapEndian(FILE *bmp, unsigned char *buffer, std::bitset<32> &bits) {
        std::fread(buffer,1,4,bmp);
        //Endian Swap
        bits = buffer[0];
        bits = (bits << 8) | (std::bitset<32>)buffer[1];
        bits = (bits << 8) | (std::bitset<32>)buffer[2];
        bits = (bits << 8) | (std::bitset<32>)buffer[3];
}

void Bitmap::halfLoop(unsigned const int x, unsigned const int y, std::bitset<32> bits) {
    //First Loop only reads remaining bits in a DWORD and skips the Packing bits
    for (offbits = 0; offbits < (width % 32); offbits++){
        //Bit Loop to print out pixel data but skips the packing bits
        this->renderDWORD(bits,x,y);
    }
    row++;
    colomn = 0;
}

void Bitmap::fullLoop(unsigned const int x, unsigned const int y, std::bitset<32> bits) {
    //Second Loop reads the full DWORD
    for (offbits = 0; offbits < 32; offbits++) {
        this->renderDWORD(bits,x,y);
    }
}

//Aiding Funtion for fullloop and halfloop
void Bitmap::renderDWORD(std::bitset<32> bits, unsigned int const x, unsigned int const y) {
    bool state;
    if (bits[31 - offbits] == 1) {
        state = false;
    } else {
        state = true;
    }
    this->setPixel((colomn + x) ,(row + y),state);
    colomn++;
}