#ifndef SCENEFUNCTIONS_H
#define SCENEFUNCTIONS_H

/** SceneFunctions Class
@brief Contains Private Functions for each Pre Event and Pos Event. SceneFunctions is friend and parent to SceneCreator.
@breif Also contains ultity functions like button locks and small animation sequences

@author Saad Tayyab
@date 25th April 2019
*/
#include "mbed.h"
#include "Bitmap.h"
#include "CaMove.h"
#include "WDplayer.h"

class SceneFunctions  {
    friend class SceneCreator;
    
    private :
    //Hardware pointers
    DigitalIn *_BOK;
    //Private Variables
    int _progress; //for Fucntions that require Completion path (e.g do this then this to open)
    bool _p[3];
    
    //constructor functions
    void set_buttonPin(PinName pin);
    void deletebutton();
    void reset_variables();
    
    //Ultility Functions
    void transition(Bitmap &lcd); //transition effect
    void lockin(Bitmap &lcd);     //stops program until user presses button
    void flash(Bitmap &lcd);      //makes screen flash
    
    //Obj Functions create dissapearing or appearing Objects - pre- function (occurs before everything else) 
    //Event Functions used to create mini instances due to a user clicking something
    
    //scene 0 Functions
    void set_scene0(CaMove &CM);
    //pre functions objs
    void obj0_scene0(Bitmap &lcd);
    //pos functions events
    void event0_scene0(Bitmap &lcd);
    void event1_scene0(Bitmap &lcd);
    
    //scene 1 Functions
    void set_scene1(CaMove &CM);
    //pre
    void obj0_scene1(Bitmap &lcd);
    void obj1_scene1(Bitmap &lcd);
    //pos
    void event0_scene1(Bitmap &lcd);
    void event1_scene1(Bitmap &lcd,CaMove &CM);
    
    //Scene2 Functions
    void set_scene2(CaMove &CM);
    //pre functions
    void obj0_scene2(Bitmap &lcd);
    void obj1_scene2(Bitmap &lcd,int rng);
    //pos functions
    void event0_scene2(Bitmap &lcd,CaMove &CM,WDplayer &wav);
    
    //Scene 3 Function
    void set_scene3(CaMove &CM);
    //pre function
    void obj0_scene3(Bitmap &lcd);
    void obj1_scene3(Bitmap &lcd);
    void obj3_scene3(Bitmap &lcd);
    void obj4_scene3(Bitmap &lcd);
    //pos function
    void event0_scene3(Bitmap &lcd);
    void event1_scene3(Bitmap &lcd);
    void event2_scene3(Bitmap &lcd);
    void event3_scene3(Bitmap &lcd,CaMove &CM);
    
    //Scene 4 Function
    void set_scene4(CaMove &CM);
    //pre functions
    void obj1_scene4(Bitmap &lcd);
    void obj2_scene4(Bitmap &lcd,int rng);
    void obj3_scene4(Bitmap &lcd);
    //pos function
    void event0_scene4(Bitmap &lcd,CaMove &CM,WDplayer &wav);
    
};

#endif