#include "SceneFunctions.h"
#include "MiscPaths.h"

//Constructor Functions
void SceneFunctions::set_buttonPin(PinName pin) {
    _BOK = (new DigitalIn(pin));
    _BOK->mode(PullDown);
    _progress = 0;
    _p[0] = true;
    _p[1] = true;
    _p[2] = true;
}

void SceneFunctions::reset_variables() {
    _progress = 0;
    _p[0] = true;
    _p[1] = true;
    _p[2] = true;
}

void SceneFunctions::deletebutton() {
     delete _BOK;
}

//Ultility Functions
void SceneFunctions::transition(Bitmap &lcd) {
    for (int i = 0;i < 84;i++) {
    lcd.drawRect(0,0,i,48,FILL_BLACK);
    lcd.refresh();
    }
    for (int i = 0;i < 84;i++) {
    lcd.drawRect(0,0,i,48,FILL_WHITE);
    lcd.refresh();
    }
}

void SceneFunctions::lockin(Bitmap &lcd) {
    while (_BOK->read() == 0) {
        lcd.printString("             ",0,5);
        lcd.refresh();
        wait(0.15);
        lcd.printString("...Press B...",0,5);
        lcd.refresh();
        wait(0.15);
    }
}

void SceneFunctions::flash(Bitmap &lcd) {
        for(int i = 0; i < 4; i++)  {
            lcd.drawRect(0,0,84,48,FILL_BLACK);
            lcd.refresh();
            wait(0.15);
            lcd.drawRect(0,0,84,48,FILL_WHITE);
            lcd.refresh();
            wait(0.15);
        };
};

//Unique to Scene Functions
//scene 0 Functions
void SceneFunctions::set_scene0(CaMove &CM) {
    CM.set_region(1, 28, 12, 17); //event 0
    CM.set_region(66, 15, 21, 24);   //event 1
};
//pre funtions
void SceneFunctions::obj0_scene0(Bitmap &lcd) {
    lcd.drawRect(32,1,20,2,FILL_BLACK);
};
//pos functions
void SceneFunctions::event0_scene0(Bitmap &lcd) {
    this->transition(lcd);
    lcd.clear();
    lcd.printString("Hello My Name",0,0);
    lcd.printString("Veigar I Shall",0,1);
    lcd.printString("Help You Find",0,2);
    lcd.printString("What You Seek",0,3);
    lcd.printString("Now go ... ",0,4);
    lcd.refresh();
    this->lockin(lcd);
    this->transition(lcd);
}

//event 1
void SceneFunctions::event1_scene0(Bitmap &lcd) {
    this->transition(lcd);
    lcd.clear();
    lcd.printString("It's a Weird",0,0);
    lcd.printString("quite eerie...",0,1);
    lcd.printString("Statue !!",0,2);
    lcd.refresh();
    this->lockin(lcd);
    this->transition(lcd);
}

//scene1 Funtions
void SceneFunctions::set_scene1(CaMove &CM) {
    CM.set_region(2, 38, 8, 7); //event 0
    CM.set_region(72, 2, 8, 7);   //event 1
};

//pre funtions
void SceneFunctions::obj0_scene1(Bitmap &lcd) {
    lcd.drawLine(30,40,31,20,0);
    lcd.drawLine(55,40,55,20,1);
    lcd.drawRect(5,1,20,2,FILL_BLACK);
}

void SceneFunctions::obj1_scene1(Bitmap &lcd) {
    lcd.drawRect(32,1,20,2,FILL_BLACK);
}


//pos functions
void SceneFunctions::event0_scene1(Bitmap &lcd) {
    lcd.drawRect(74,3,6,3,FILL_WHITE);
    lcd.drawLine(4,39,7,41,1);
    lcd.refresh();
    wait(0.2);
    lcd.drawRect(74,3,6,3,FILL_WHITE);
    lcd.drawLine(9,39,7,41,1);
    lcd.refresh();
    wait(0.2);
}

void SceneFunctions::event1_scene1(Bitmap &lcd,CaMove &CM) {
    lcd.drawRect(74,3,6,3,FILL_WHITE);
    lcd.drawLine(74,3,77,5,1);
    lcd.refresh();
    wait(0.2);
    lcd.drawRect(74,3,6,3,FILL_WHITE);
    lcd.drawLine(79,3,77,5,1);
    lcd.refresh();
    wait(0.2);
    CM.spawn(42,-15);
}

//Scene 2 Functions
void SceneFunctions::set_scene2(CaMove &CM) {
    CM.set_region(9, 17, 10, 14); //event 0
    
};
//pre Functions
void SceneFunctions::obj0_scene2(Bitmap &lcd) {
    lcd.renderBMP(MISC[0],9,17);
    lcd.drawLine(83,13,83,33,1); //right
    lcd.drawLine(47,0,67,0,1); // top
    lcd.drawLine(47,47,67,47,1); //bot
}

void SceneFunctions::obj1_scene2(Bitmap &lcd,int rng) {
    switch(rng) {
    case 0:
        lcd.drawLine(83,13,83,33,1); //r
        lcd.drawLine(47,0,67,0,1); // t
    break;
    case 1:
        lcd.drawLine(47,47,67,47,1); //b
        lcd.drawLine(83,13,83,33,1); //r
    break;
    case 2:
        lcd.drawLine(47,47,67,47,1); //b
        lcd.drawLine(47,0,67,0,1); // t
    break;
    }
}

//pos Function
void SceneFunctions::event0_scene2(Bitmap &lcd,CaMove &CM,WDplayer &wav) {
    this->transition(lcd);
    lcd.clear();
    lcd.renderBMP(MISC[1],0,0);
    lcd.refresh();
    wait(1);
    CM.delete_regions();
    lcd.clear();
    lcd.printString("Help Me Please",0,0);
    lcd.refresh();
    wait(0.5);
    lcd.printString("I NEED YOUR",0,1);
    lcd.printString("BLOOOD !!!",0,2);
    lcd.refresh();
    wait(1);
    CM.init(35,17,Fd);
    CM.spawn(9,17);
    lcd.inverseMode();
}

//Scene 3 Functions
void SceneFunctions::set_scene3(CaMove &CM) {
    CM.set_region(72, 39, 10, 7);  //event 0
    CM.set_region(73, 11, 10, 17); //event 1
    CM.set_region(64, 5, 10, 14);  //event 2
    CM.set_region(42, 2, 11, 18);  //event 3
};

//pre Functions
void SceneFunctions::obj0_scene3(Bitmap &lcd) {
    lcd.drawLine(76,42,78,40,1);
    lcd.drawRect(74,40,2,3,FILL_WHITE);
    lcd.drawRect(28,29,11,13,FILL_WHITE);
    lcd.drawRect(14,31,9,11,FILL_BLACK);
    lcd.drawLine(16,33,20,33,0);
    lcd.drawLine(20,33,20,37,0);
    lcd.drawLine(20,37,16,37,0);  
}

void SceneFunctions::obj1_scene3(Bitmap &lcd) {
    lcd.setPixel(77,14,false);
}

void SceneFunctions::obj3_scene3(Bitmap &lcd) {
    lcd.renderBMP(MISC[2],21,8);
}

void SceneFunctions::obj4_scene3(Bitmap &lcd) {
    if (_progress < 3) {
        lcd.drawRect(55,46,16,2,FILL_BLACK);
    }
}

//pos functions
void SceneFunctions::event0_scene3(Bitmap &lcd) {
    if(_p[0]) {
        _p[0] = false;
        _progress++;
    }
}


void SceneFunctions::event1_scene3(Bitmap &lcd) {
    this->transition(lcd);
    lcd.clear();
    lcd.printString("The Statue",0,0);
    lcd.printString("Looks like a",0,1);
    lcd.printString("Head But Eye",0,2);
    lcd.printString("Missing I Stab",0,3);
    lcd.printString("In a New One.",0,4);
    lcd.refresh();
    if(_p[2]) {
        _p[2] = false;
        _progress++;
    }
    this->lockin(lcd);
    this->transition(lcd);
}


void SceneFunctions::event2_scene3(Bitmap &lcd) {
    this->transition(lcd);
    lcd.clear();
    lcd.printString("Welcome to",0,0);
    lcd.printString("Mirror Room",0,1);
    lcd.printString("But Beware Not",0,2);
    lcd.printString("Touch Sarced",0,3);
    lcd.printString("!!!ITEM!!!",0,4);
    lcd.refresh();
    if(_p[1]) {
        _p[1] = false;
        _progress++;
    }
    this->lockin(lcd);
    this->transition(lcd);
}

void SceneFunctions::event3_scene3(Bitmap &lcd,CaMove &CM) {
    this->transition(lcd);
    lcd.clear();
    CM.delete_regions();
    lcd.printString("CURSE YOU",0,0);
    lcd.refresh();
    wait(0.5);
    CM.spawn(21,8);
    lcd.inverseMode();
}

//Scene 4 Functions
void SceneFunctions::set_scene4(CaMove &CM) {
    CM.set_region(14, 16, 3, 20);  //event 0
}
//pre functions
void SceneFunctions::obj1_scene4(Bitmap &lcd) {
    if (_progress < 5) {
        _progress = 7;
    }
    if (_progress < 15) {
       lcd.drawRect((20 -_progress),18,2,18,FILL_BLACK);
    } 
}
void SceneFunctions::obj2_scene4(Bitmap &lcd,int rng) {
    switch(rng) {
        case 2:
        lcd.renderBMP(MISC[0],4,2);
        break;
        case 0:
        lcd.renderBMP(MISC[2],4,2);
        break;
    }
}
void SceneFunctions::obj3_scene4(Bitmap &lcd) {
    if (_progress > 7) {
        switch (_progress) {
        default:
        case 15:
            lcd.drawLine(45,4,45,10,1);
        case 14:
            lcd.drawLine(45,4,49,7,1);
        case 13:
            lcd.drawLine(49,7,45,10,1);
        case 12:
            lcd.drawLine(54,5,55,10,1);
        case 11:
            lcd.drawLine(61,4,59,10,1);
        case 10:
            lcd.drawLine(61,4,66,3,1);
        case 9:
            lcd.drawLine(59,10,65,9,1);
        case 8:
            lcd.drawLine(66,7,60,7,1);
        break;
        }
    }
}
Serial x(USBTX,USBRX);
//pos function
void SceneFunctions::event0_scene4(Bitmap &lcd,CaMove &CM,WDplayer &wav) {
    if (_progress == 8) {
        CM.spawn(84,19);
    }
    CM.delete_regions();
    CM.set_region((18 - _progress),17,6,18);
    _progress++;
}