#ifndef GAME_MANAGER_H
#define GAME_MANAGER_H


/** Game_Manager Class
@brief Class for Managing all Game Libraies those being CaMove,Bitmap,SceneCreator,WDplayer
@brief Only for RPG game Titles, It also runs File Path Checks and Animation Scenes

@author Saad Tayyab
@date 6th May 2019

@code
#include "mbed.h"
#include "Game_Manager.h"

//Constructor for Game_Manager
Game_Manager GM(PTE3, PTE1, PTE2, PTE4, PTC9,PTC0,PTC7,PTD2,PTD1,PTC11, PTB9,PTB11,PTB10,PTC10,PTD0,PTC5); 

int main() {
    if (!GM.boot_error()) { //File Checks
        GM.menu();      //Splash Screen
        GM.tutorial();  //Tutorial Screens
        GM.main();     //Main Game
        wait(1);
    }   
}
@endcode
*/

#include "mbed.h"
#include "WDplayer.h"
#include "SDFileSystem.h"
#include "Bitmap.h"
#include "CaMove.h"
#include "SceneCreator.h"

class Game_Manager {
    
    public:
    /** Construtor
     *
     *@param mosi SD card mosi Pin
     *@param miso SD Card miso Pin
     *@param sclk SD Card Sclk Pin
     *@param cs   SD Card chip select
     *@param sce  Pin for LCD chip enable for Bitmap Constructor
     *@param rst  Pin for LCD reset for Bitmap Constructor
     *@param dc   Pin for LCD data select for Bitmap Constructor
     *@param mosi Pin for LCD data input for Bitmap Constructor
     *@param sclk Pin for LCD serial clock for Bitmap Constructor
     *@param led  Pin for LCD LED backlight for Bitmap Constructor
     *@param b1 Pin for the button to control interations.
     *@param jh Pin for the joystick horizontal.
     *@param jv Pin for the joystick vertical.
     *@param wd Pin for Buzzer or speaker.
     *@param b2 Pin for second Interative button.
     *@param start Pin for third Start Game Button.
     */
    Game_Manager(PinName mosi,
                 PinName miso,
                 PinName sclk,
                 PinName cs,
                 PinName sce,
                 PinName rst,
                 PinName dc,
                 PinName mosilcd,
                 PinName sclklcd,
                 PinName led,
                 PinName b1,
                 PinName jh,
                 PinName jv,
                 PinName wd,
                 PinName sc,
                 PinName start );
    /** Destructor */
    ~Game_Manager();
    /** Function to Check if all Game Files are Present
     *@return true if missing and false if complete
     */
    bool boot_error();
    /**Function that runs Game splash screen */
    void main();
    /**Function that runs Game instance */
    void menu();
    /**Function that runs Game tutorial screens */
    void tutorial();
    
    private:
    //Boot Internal Functions
    bool check();
    void boot_msg(int opt);
    
    //First Scene with Intialization
    void first_scene(int &Random);
    
    //Ending Aniamtions
    void end_game(int Random); //Main
    void endingG();
    void endingB();
    void endingD();
    
    //Tutorial Message Functions
    void tut_msg0();
    void tut_msg1();
    void tut_msg2();
    void tut_msg3();
    void tut_msg4();
    void tut_msg5();
    
    //Hardware Pointers
    SDFileSystem *sd;
    Bitmap *lcd;
    CaMove *CM;
    WDplayer *wav;
    SceneCreator *SNC;
    DigitalIn *str;

};

#endif