#include "Game_Manager.h"
#include "AllPaths.h"

Timer Time;
Serial PC(USBTX,USBRX);

Game_Manager::Game_Manager(PinName mosi,
                           PinName miso,
                           PinName sclk,
                           PinName cs,
                           PinName sce,
                           PinName rst,
                           PinName dc,
                           PinName mosilcd,
                           PinName sclklcd,
                           PinName led,
                           PinName b1,
                           PinName jh,
                           PinName jv,
                           PinName wd,
                           PinName sc,
                           PinName start )
        :
        sd(new SDFileSystem(mosi, miso, sclk, cs, "sd")),
        lcd(new Bitmap(sce,rst,dc,mosilcd,sclklcd,led)),
        CM(new CaMove(b1,jh,jv)),
        wav(new WDplayer(wd)),
        SNC(new SceneCreator(sc)),
        str(new DigitalIn(start))
{ 
    str->mode(PullDown);
};

Game_Manager::~Game_Manager() {
    delete (sd);
    delete (lcd);
    delete (CM);
    delete (wav);
    delete (SNC);
    delete (str);
}

bool Game_Manager::boot_error() {
    //Check SD card Status
    lcd->init();
    this->boot_msg(0);
    sd->disk_initialize();
    int check = sd->disk_status();
    if (check == 1) {
        this->boot_msg(1);
        return true;
    } else {
        std::cerr << "Error Report" << std::endl;
        if (this->check()) {
            this->boot_msg(2);
            return true;
        } else {
            std::cerr << "Boot Successful No Errors" << std::endl;
        }
    }
    return false;
}

void Game_Manager::boot_msg(int opt) {
    lcd->clear();
    switch(opt) {
        case 0:
            lcd->printString("BOOTING...",0,0);
        break;
        case 1:
            lcd->printString("SD Card Error",0,0);
            lcd->printString("Details in ",0,1);
            lcd->printString("Terminal try",0,2);
            lcd->printString("Re-inserting",0,3);
            lcd->printString("SD Card",0,4);
        break;
        case 2:
            lcd->printString("Game Files",0,0);
            lcd->printString("Missing",0,1);
            lcd->printString("Details in",0,2);
            lcd->printString("Terminal",0,3);
        break;
    }
    lcd->refresh();
}

void Game_Manager::first_scene(int &Random){
    //Initializing 
    SNC->set_dead(false);
    Time.start();
    wav->intWD(All[55], true);
    SNC->Scenesp(*lcd,*CM,0,40,20,Fd,0,*wav);
    Time.stop();
    Random = ((int)(Time.read()*10)) % 3;
    Time.reset();
}

void Game_Manager::main() {
    int Random;
    this->first_scene(Random);
    PC.printf("%d\n",Random);
    if (Random == 1) {
        wav->intWD(All[55], true);
        SNC->Scenesp(*lcd,*CM,3,58,26,Bd,Random,*wav); //mirror
    } else {
        wav->intWD(All[57], true);
        SNC->Scenesp(*lcd,*CM,1,35,29,Fd,Random,*wav); //fork
    }
    wav->intWD(All[56], true);
    SNC->Scenesp(*lcd,*CM,4,69,19,Rt,Random,*wav); //corridor
    if (Random != 1) {
        SNC->set_dead(false);    
        wav->intWD(All[56], true);
        SNC->Scenesp(*lcd,*CM,2,61,17,Lt,Random,*wav); //chase
    }
    this->end_game(Random);
}

void Game_Manager::end_game(int Random) {
    lcd->normalMode();
    if (SNC->get_dead()) {
        this->endingD();
    } else if (Random == 1) {
        this->endingG();
    } else {
        this->endingB();
    }
}
void Game_Manager::menu() {
       lcd->clear();
       lcd->renderBMP(All[32],0,7);
       lcd->printString(".SOUL.SEEKER..",0,0);
       while (str->read() == 0) {
           lcd->printString("Press Start",8,5);
           wait(0.15);
           lcd->refresh();
           lcd->printString("              ",0,5);
           wait(0.15);
           lcd->refresh();
       }
}

void Game_Manager::endingG() {
    for (int i = 42;i <= 50;i++) {
        lcd->clear();
        lcd->renderBMP(All[i],0,0);
        lcd->refresh();
        wait(0.5);
    }
}

void Game_Manager::endingB() {
    for (int i = 42;i <= 49;i++) {
        lcd->clear();
        lcd->renderBMP(All[i],0,0);
        lcd->refresh();
        wait(0.5);
    }
    for (int i = 51;i <= 54;i++) {
        lcd->clear();
        lcd->renderBMP(All[i],0,0);
        lcd->refresh();
        wait(0.5);
    }
}

void Game_Manager::endingD() {
    for (int i = 33;i <= 41;i++) {
        lcd->clear();
        lcd->renderBMP(All[i],0,0);
        lcd->refresh();
        wait(0.5);
    }
}

void Game_Manager::tutorial() {
    this->tut_msg5();
    if (str->read() == 0) {
      this->tut_msg0();
      this->tut_msg1();
      this->tut_msg2();
      this->tut_msg3();
    }
    this->tut_msg4();
}

void Game_Manager::tut_msg0() {
    lcd->clear();
    lcd->printString("How.to.Play.?..",0,0);
    lcd->printString("A - Button is",0,1);
    lcd->printString("used to check",0,2);
    lcd->printString("objects. make",0,3);
    lcd->printString("sure you face",0,4);
    lcd->printString("the object.",0,5);
    lcd->refresh();
    wait(3);
}

void Game_Manager::tut_msg1() {    
    lcd->clear();
    lcd->printString("How.to.Play.?..",0,0);
    lcd->printString("Use the ",0,2);
    lcd->printString("Joystick to ",0,3);
    lcd->printString("Move.",0,4);
    lcd->refresh();
    wait(3);
}

void Game_Manager::tut_msg2() {
    lcd->clear();
    lcd->printString("In.Game.Help....",0,0);
    lcd->printString("Whenever you",0,2);
    lcd->printString("progress the",0,3);
    lcd->printString("the screen ",0,4);
    lcd->printString("flash like...",0,05);
    lcd->refresh();
    wait(3);
    SNC->flashy(*lcd);
}

void Game_Manager::tut_msg3() {
    lcd->clear();
    lcd->printString("In.Game.Help....",0,0);
    lcd->printString("Objective is",0,2);
    lcd->printString("to progress",0,3);
    lcd->printString("each scene",0,4);
    lcd->refresh();
    wait(4);
}

void Game_Manager::tut_msg4() {
    lcd->clear();
    lcd->printString(".The.Story...",0,0);
    lcd->printString("Something has",0,2);
    lcd->printString("been stolen",0,3);
    lcd->printString("from you find",0,4);
    lcd->printString("that which gone",0,5);
    lcd->refresh();
    wait(4);
    SNC->flashy(*lcd);
}

void Game_Manager::tut_msg5() {
    lcd->clear();
    lcd->printString(".Tutorial....",0,0);
    lcd->printString("Hold start to",0,2);
    lcd->printString("skip now else",0,3);
    lcd->printString("    wait     ",0,4);
    lcd->refresh();
    wait(3);
}

bool Game_Manager::check() {
    FILE *bmp;
    bool error = false;
    for (int i = 0; i <= 57; i++) {
        bmp = fopen(All[i],"r");
        if (bmp == NULL) {
            std::cerr << All[i] << " is not present" << std::endl;
            error = true;
        } else {
            fclose(bmp);
        }
    }
    return error;
}
