#include "CaMove.h"
#include "AniPaths.h"

//Constructor
CaMove::CaMove(PinName Button, 
               PinName Pot_h, 
               PinName Pot_v)
        : //Creating Class Objects
        _check(new InterruptIn(Button)), 
        _hoz(new AnalogIn(Pot_h)),
        _ver(new AnalogIn(Pot_v))
    {
    _check->mode(PullDown);
    _check->rise(callback(this,&CaMove::intercheck));
};

//Destructor
CaMove::~CaMove() {
    delete _check;
    delete _hoz;
    delete _ver;
};

//Initilizing Functions
//Player
void CaMove::init(int x,int y,Direction D) {
    _h = x;
    _v = y;
    _itr = 0;
    _fc = D;
    _trg = false;
    _treg = -1;
};

//AI Chasers
void CaMove::AIinit(int chaser) {
    enabled = false;
    _ch = 0;
    _cv = 0; //Increment is speed of Chaser
    switch (chaser) {
        case 2:
        increment = 2;
        break;
        case 1:
        increment = 0;
        break;
        case 4:
        increment = 5;
        break;
        default:
        increment = 3;
        break;
    }
};

//Player Functions

void CaMove::move(Bitmap &lcd) {
    //If statements to check joystick movement and has in bluilt collsion detection
    //collsion detection check 4 sides for black pixels
    bool left = (lcd.getPixel((_h-1),(_v+12)) == 0 &&  lcd.getPixel((_h-1),(_v+1)) == 0) ; 
    bool right = (lcd.getPixel((_h+10),(_v+12)) == 0 && lcd.getPixel((_h+10),(_v+1)) == 0);
    bool down = (lcd.getPixel((_h+1),(_v-1)) == 0 && lcd.getPixel((_h+8),(_v-1)) == 0); 
    bool up = (lcd.getPixel((_h+1),(_v+14)) == 0 && lcd.getPixel((_h+8),(_v+14)) == 0);
    this->check_collision(left,right,down,up);
    if (_itr == 3) {
        _itr = -1;
    }
    _itr++;
    this->rend(lcd);
}

bool CaMove::in_screen() {
    if (_h + 5 >= 84 || (_h + 5) <= 0 || _v + 7 >= 48 || (_v + 8) <= 0) {
        return false;
    } else {
        return true;
    }
};

//Aiding Player Functions

void CaMove::check_collision(bool left,bool right,bool down,bool up) {
    //Checks Input on Joystick and Verifies if charater can move in that direction
    if (_hoz->read() > 0.6f && left) {
        _h = _h - 2;
        _fc = Lt;
    }
    if (_hoz->read() < 0.4f && right) {
        _h = _h + 2;
        _fc = Rt;
    }
    if (_ver->read() > 0.6f && down) {
        _v = _v - 2;
        _fc = Fd;
    }
    if (_ver->read() < 0.4f && up) {
        _v = _v + 2;
        _fc = Bd;
    }   
}

void CaMove::rend(Bitmap &lcd) {
    //Switch case allows charater to move diagonally and retains its facing direction when stationary
    switch (_fc) {
            case Lt:
            lcd.renderBMP(L[_itr],_h,_v); //render Charater on Screen
            break;       
            case Rt:
            lcd.renderBMP(R[_itr],_h,_v);
            break;
            case Fd:
            lcd.renderBMP(F[_itr],_h,_v);
            break;
            case Bd:
            lcd.renderBMP(B[_itr],_h,_v);
            break;
        }
};

//Interactive Region Function pack
//Setting regions
void CaMove::set_region(int xmin, int ymin, int xl, int yl) { //Sets values into vector
    _vreg.push_back((xmin + xl));
    _vreg.push_back(xmin);
    _vreg.push_back((ymin + yl));
    _vreg.push_back(ymin);
};

void CaMove::delete_regions() {
    _vreg.clear();
};

//Interupting Function
void CaMove::intercheck() {
    _trg = false;         //reset everytime called
    LowerH = false;
    UpperH = false;
    MidH = false;
    LowerV = false;
    UpperV = false;
    MidV = false;
    if (_vreg.size() > 0) {       //checks all regions for vector
        for(int Vvalue = 0; Vvalue < _vreg.size(); Vvalue = Vvalue +4) {
            this->set_statements(Vvalue);  //returns checked regions if in an Region
            this->check_sides(Vvalue);     //focuses on regions in facing direction
        }
    }
};


//Internal Functions
void CaMove::set_statements(int Vvalue) {
    //If Statements check that sides position with all x- y region ranges to see if charater has hit that region.
    LowerH = (_h - 1) <= _vreg[Vvalue] && (_h-1) >= _vreg[Vvalue + 1];
    UpperH = (_h + 10) <= _vreg[Vvalue] && (_h + 10) >= _vreg[Vvalue + 1];
    MidH = (_h + 5) <= _vreg[Vvalue] && (_h + 5) >= _vreg[Vvalue + 1];
    LowerV = (_v - 1) >= _vreg[Vvalue + 3] && (_v - 1) <= _vreg[Vvalue + 2];
    UpperV = (_v+14) >= _vreg[Vvalue + 3] && (_v + 14) <= _vreg[Vvalue + 2];
    MidV = (_v+7) >= _vreg[Vvalue + 3] && (_v + 7) <= _vreg[Vvalue + 2];
}

void CaMove::check_sides(int Vvalue) {
    switch (_fc) {        //Function only will check the facing side for interative regions
            case Lt:           //L
                if (LowerH && MidV) {
                    this->set_treg(Vvalue); //returns region number
                };
            break;
            case Rt:          //R
                if (UpperH && MidV) {
                    this->set_treg(Vvalue);
                }
            break;
            case Fd:         //F
                if (MidH && LowerV) {
                    this->set_treg(Vvalue);
                }
            break;
            case Bd:         //B
                if (MidH && UpperV) {
                    this->set_treg(Vvalue);   
                }
            break;
        }
}

//Aiding Functions

void CaMove::set_treg(int Vvalue) {
    //The region number is found depending on its position in the vector
    //e.g elements 0 to 3 are in region 0 and elements 4 to 7 are in region 1
    _trg = true;
    _treg = Vvalue / 4;
}

//Accessors

//Functions revert to default values evrytime they are called. 
bool CaMove::is_trg() {  
    bool temp = _trg;
    _trg = false;
    return temp;

};

int CaMove::get_treg() {
    int temp = _treg;
    _treg = -1;
    return temp;
}



//Chaser Functions

void CaMove::spawn(int x, int y) { //Chaser Appears
    enabled = true;
    _ch = x;
    _cv = y;
}


bool CaMove::is_caught() {
    if (abs(_ch - _h) < 10 && abs(_cv - _v) < 14 && enabled) {
        return true;
    } else {
        return false;
    }
}

void CaMove::chase(Bitmap &lcd, int girl) {
    if (enabled) {
        if (_cv < _v) {
            _cv = _cv + increment;
        } else if (_cv > _v) {
            _cv = _cv - increment;
        }
        if (_ch < _h) {
            _ch = _ch + increment;
        } else if (_ch > _h) {
            _ch = _ch - increment;
        }
        this->render_chaser(lcd,girl);
    }
}

//Internal Functions

void CaMove::render_chaser(Bitmap &lcd,int chaser) {
    switch (chaser) {
        case 2:
        lcd.renderBMP(AIC[_itr],_ch,_cv);
        break;
        case 4:
        lcd.renderBMP(AIC[_itr],_ch,_cv); // change later
        break;
        default:
        lcd.renderBMP(AIM[_itr],_ch,_cv);
        break;
    }
}