#include "Enemy2.h"

Enemy2::Enemy2()
{

}

Enemy2::~Enemy2()
{

}

void Enemy2::init(int x,int y)
{
  x_enem = x;
  y_enem = y;
}

// resets incrementer to 0 //
void Enemy2::resetIncrementer(){
  _incrementer_enem2 = 0;
}

int Enemy2::get_x_enem()
{
  return x_enem;
}

int Enemy2::get_y_enem()
{
  return y_enem;
}

void Enemy2::drawSpriteB(N5110 &lcd)
{
  lcd.drawSprite(x_enem, y_enem,7,7,(int *)enemy_B);
}

void Enemy2::drawSprite2(N5110 &lcd)
{
  lcd.drawSprite(x_enem, y_enem,7,7,(int *)enemy_2);
}

void Enemy2::drawSpriteC(N5110 &lcd)
{
  lcd.drawSprite(x_enem, y_enem,7,7,(int *)enemy_C);
}

void Enemy2::movementB(N5110 &lcd)
{
  // incrementer increments 1 for every pixel enemyB needs to move //
  // and thus it's possible to create a straight path //
  accel = 1;
  _incrementer_enem2++;
  if ( _incrementer_enem2 == 28 ) {
    _incrementer_enem2 = 0;
  }
  if ( _incrementer_enem2 >= 0 && _incrementer_enem2 <= 13) {
    y_enem++;
  } else if ( _incrementer_enem2 >= 14 && _incrementer_enem2 <= 27) {
      y_enem--;
  }
}

void Enemy2::movement2(N5110 &lcd)
{
  // incrementer increments 1 for every pixel enemy2 needs to move //
  // and thus it's possible to create a straight path //
  accel = 1;
  _incrementer_enem2++;
  if ( _incrementer_enem2 == 24 ) {
    _incrementer_enem2 = 0;
  }
  if ( _incrementer_enem2 >= 0 && _incrementer_enem2 <= 11) {
    y_enem--;
  } else if ( _incrementer_enem2 >= 12 && _incrementer_enem2 <= 23) {
      y_enem++;
  }
}

void Enemy2::movementC(N5110 &lcd)
{
  // incrementer increments 1 for every pixel enemyC needs to move //
  // and thus it's possible to create a straight path //
  accel = 1;
  _incrementer_enem2++;
  if ( _incrementer_enem2 == 58 ) {
    _incrementer_enem2 = 0;
  }
  if ( _incrementer_enem2 >= 0 && _incrementer_enem2 <= 28) {
    x_enem++;
  } else if ( _incrementer_enem2 >= 29 && _incrementer_enem2 <= 57) {
      x_enem--;
  }
}

bool Enemy2::collidePlayer(int x, int y, Gamepad &pad)
{
  // if collision detected then tone plays //
  for (int ix = 0; ix < 7; ix++) {
    for (int iy = 0; iy < 7; iy++) {
      if ( x + ix == x_enem + 3 && y + iy == y_enem + 3 ) {
        pad.tone(400,0.5);
        return true;
      }
    }       
  }
  return false;
}