/*
Name: Spencer Tingle
Username: el17set
Student ID: 201147893
Date: 09/05/19
*/

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Game.h"
#include "Menu.h"
#include "Coin.h"

// objects //
Game game;
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;

// prototypes //
void init();
void render();
void startScreen();
bool gameWin();

// functions //
int main()
{
  int fps = 30;          // set frames per second 
  lcd.setContrast(0.4);  // set contrast
  lcd.setBrightness(1);  // set brightness
    
  init();               // initialises all initial variables
  startScreen();        // displays start screen until start pressed
  wait(1.0f/fps);       // sets wait between next frame

  // game loop //
  while (1) { 
    game.UI(lcd, pad);  // displays the menus
    game.init();
    int health = game.get_health();
    
    // condition to allow for returning to // 
    // main menu on win or loss //
    while (health > 0) {
      render();
      wait(1.0f/fps);
      health = game.get_health();
    }  
  }
}

// initialises gamepad and lcd //
void init()
{
  lcd.init();
  pad.init();
}

// updates all sprites and updates all movements //
// and conditional values every frame //
void render()
{
  lcd.clear();
  game.direc(pad);
  game.drawSprite(lcd);
  game.movement(lcd, pad);
  game.collect(lcd, pad);
  game.win(lcd);
  game.damage(lcd, pad);
  game.death(lcd);
  game.display_health(lcd);
  lcd.refresh();
}

// start screen with 3 frames //
void startScreen()
{
  // until start pressed 3 frames will loop //
  while (pad.check_event(Gamepad::START_PRESSED) == false) {
    lcd.clear();
    lcd.drawSprite(0,0,48,84,(int *)start_01);
    lcd.refresh();
    wait(0.5);
    lcd.drawSprite(0,0,48,84,(int *)start_02);
    lcd.refresh();
    wait(0.5);
    lcd.drawSprite(0,0,48,84,(int *)start_03);
    lcd.refresh();
    wait(0.5);
  }
}