#ifndef GAME_H
#define GAME_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Menu.h"
#include "Baby.h"
#include "Maze.h"
#include "Enemy1.h"
#include "Enemy2.h"
#include "Coin.h"

/** Game class

@brief Class of all game functions called in main.cpp 

@version 1.0

@author Spencer Tingle

@date 09/05/19

*/

class Game{

 public:

  Game();
  ~Game();
  /** 
  * @brief Init
  * @details Initiates coordinates of sprites and values
  */
  void init();
  /** 
  * @brief Gets current health
  * @details Health set intially to 10
  */
  int get_health();
  /** 
  * @brief Gets current direction of joystick
  */
  void direc(Gamepad &pad);
   /** 
  * @brief Displays current health
  * @param N5110 &lcd @details Health displayed in bottom left corner of lcd
  */
  void display_health(N5110 &lcd);
   /** 
  * @brief Draws all sprites
  * @param N5110 &lcd @details Draws sprites at coordinates specified in init()
  */
  void drawSprite(N5110 &lcd);
   /** 
  * @brief Move sprites
  * @param N5110 &lcd @details Allows for movement of player and enemies
  */
  void movement(N5110 &lcd, Gamepad &pad);
   /** 
  * @brief Detects collection
  * @param N5110 &lcd, Gamepad &pad 
  * @details If coin is collected then it will respawn in new game
  */
  void collect(N5110 &lcd, Gamepad &pad);
   /** 
  * @brief Win screen
  * @param N5110 &lcd @details If win condition met win screen displays
  */
  void win(N5110 &lcd);
   /** 
  * @brief Detects damage
  * @param N5110 &lcd, Gamepad &pad  
  * @details If win condition met win screen displays
  */
  void damage(N5110 &lcd, Gamepad &pad);
   /** 
  * @brief Death screen
  * @param N5110 &lcd @details If death condition met game over screen displays
  */
  void death(N5110 &lcd);
   /** 
  * @brief User Interface
  * @param N5110 &lcd, Gamepad &pad  
  * @details Displays menus on start-up and game over
  */
  void UI(N5110 &lcd, Gamepad &pad);

 private:

  Baby baby;
  Maze maze;
  Menu menu;
  Direction dir;

  Enemy1 enemyA;
  Enemy1 enemy1;
  Enemy2 enemyB;
  Enemy2 enemy2;
  Enemy2 enemyC;

  Coin coin0;
  Coin coin1;
  Coin coin2;
  Coin coin3;
  Coin coin4;
  Coin coin5;
  Coin coin6;
  Coin coin7;
  Coin coin8;
  Coin coin9;
  Coin coin10;
  Coin coin11;
  Coin coin12;
  Coin coin13;

  int x;
  int y;
  int _health;
  int coin;
};

#endif