#ifndef ENEMY2_H
#define ENEMY2_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

const int enemy_B[7][7] = {
  {1,0,0,0,0,0,0},
  {1,0,0,0,0,0,0},
  {1,0,0,0,0,0,0},
  {1,1,1,1,1,1,1},
  {1,0,0,0,0,0,1},
  {1,0,0,0,0,0,1},
  {1,1,1,1,1,1,1}

  };

const int enemy_2[7][7] = {
  {1,1,1,1,1,1,1},
  {0,0,0,0,0,0,1},
  {0,0,0,0,0,0,1},
  {1,1,1,1,1,1,1},
  {1,0,0,0,0,0,0},
  {1,0,0,0,0,0,0},
  {1,1,1,1,1,1,1}

  };

const int enemy_C[7][7] = {
  {1,1,1,1,1,1,1},
  {1,0,0,0,0,0,0},
  {1,0,0,0,0,0,0},
  {1,0,0,0,0,0,0},
  {1,0,0,0,0,0,0},
  {1,0,0,0,0,0,0},
  {1,1,1,1,1,1,1}

  };

/** Enemy2 class

@brief Class of Enemy2

@version 1.0

@author Spencer Tingle

@date 09/05/19

*/

class Enemy2{
    
 public:

  Enemy2();
  ~Enemy2();
  /** 
  * @brief Init
  * @param x, y @details Initiates coordinates of coins
  */
  void init(int x,int y);
  /** 
  * @brief Incrementer Reset
  * @details Resets incrementer used for enemy movement
  */
  void resetIncrementer();
  /** 
  * @brief Get x
  * @details Gets the enemy's current x-coordinate
  */
  int get_x_enem();
  /** 
  * @brief Get y
  * @details Gets the enemy's current y-coordinate
  */
  int get_y_enem();
  /** 
  * @brief Draw enemyB
  * @param lcd @details Draws the enemyB sprite
  */
  void drawSpriteB(N5110 &lcd);
  /** 
  * @brief Draw enemy2
  * @param lcd @details Draws the enemy2 sprite
  */
  void drawSprite2(N5110 &lcd);
  /** 
  * @brief Draw enemyC
  * @param lcd @details Draws the enemyC sprite
  */
  void drawSpriteC(N5110 &lcd);
  /** 
  * @brief Moves enemyB
  * @param lcd @details Moves the enemyB sprite
  */
  void movementB(N5110 &lcd);
  /** 
  * @brief Moves enemy2
  * @param lcd @details Moves the enemy2 sprite
  */
  void movement2(N5110 &lcd);
  /** 
  * @brief Moves enemyC
  * @param lcd @details Moves the enemyC sprite
  */
  void movementC(N5110 &lcd);
  /** 
  * @brief Detects collision
  * @param x, y, pad @details When baby and enemy collide tone plays
  */
  bool collidePlayer(int x, int y, Gamepad &pad);

 private:

  int x_enem;
  int y_enem;
  int accel;
  int _incrementer_enem2;

};

#endif