#ifndef COIN_H
#define COIN_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

const int coin_01[2][2] = {
  {1,1},
  {1,1}

  };

/** Coin class

@brief Class of the collectable coin

@version 1.0

@author Spencer Tingle

@date 09/05/19

*/

class Coin{

 public:

  Coin();
  ~Coin();
  /** 
  * @brief Init
  * @param x, y @details Initiates coordinates of coins
  */
  void init(int x, int y);
  /** 
  * @brief Get x
  * @details Gets the coin's current x-coordinate
  */
  int get_x_coin();
  /** 
  * @brief Get y
  * @details Gets the coin's current y-coordinate
  */
  int get_y_coin();
  /** 
  * @brief Get coins
  * @details Gets the current number of coins collected
  */
  int get_coins();
  /** 
  * @brief Draw coin
  * @param lcd @details Draws the coin sprite
  */
  void drawSprite(N5110 &lcd);
  /** 
  * @brief Coin collision
  * @param x, y, pad @details Detects collsions and plays tone when true
  */
  bool collidePlayer(int x, int y, Gamepad &pad);
  /** 
  * @brief Coin collision
  * @param x, y, lcd, pad @details Detects collsions and plays tone when true
  */
  void spawn(int x, int y, N5110 &lcd, Gamepad &pad);

 private:

  bool _spawn;
  int coin;
  int x_coin;
  int y_coin;
  int accel;

};

#endif