#include "Baby.h"

Baby::Baby()
{

}

Baby::~Baby()
{

}

void Baby::init(int x, int y){
  x_char = x + 13;
  y_char = y + 40;
}

int Baby::get_x_char() 
{
  return x_char;
}

int Baby::get_y_char()
{
  return y_char;
}

void Baby::drawSprite(N5110 &lcd)
{
  lcd.drawSprite(x_char,y_char,7,7,(int *)sprite_01);
}

void Baby::movement(Direction dir, N5110 &lcd)
{
  // if any direction and collision not detected then movement occurs // 
  accel = 1;
  if (dir == N && northCollision(x_char, y_char, lcd) == false) {
    y_char -= accel;
  } else if (dir == S && southCollision(x_char, y_char, lcd) == false) {
    y_char += accel;
  } else if (dir == E && eastCollision(x_char, y_char, lcd) == false) {
    x_char += accel;
  } else if (dir == W && westCollision(x_char, y_char, lcd) == false) {
    x_char -= accel;
  }
}

// each function detects collisions on one of four sides of the sprite //
bool Baby::northCollision(int x, int y, N5110 &lcd)
{
  for (int i = 0; i < 7; i++) {
    if (lcd.getPixel(x + i,y - 1) == 1) {
      return true;
    }
  }
  return false;
}

bool Baby::southCollision(int x, int y, N5110 &lcd)
{
  for (int i = 0; i < 7; i++) {
    if (lcd.getPixel(x + i,y + 7) == 1) {
      return true;
    }
  }
  return false;
}

bool Baby::eastCollision(int x, int y, N5110 &lcd)
{
  for (int i = 0; i < 7; i++) {
    if (lcd.getPixel(x + 7,y + i) == 1) {
      return true;
    }
  }
  return false;
}

bool Baby::westCollision(int x, int y, N5110 &lcd)
{
  for (int i = 0; i < 7; i++) {
    if (lcd.getPixel(x - 1,y + i) == 1) {
      return true;
    }
  }
  return false;
}
