#include "Menu.h"

Menu::Menu()
{

}

Menu::~Menu()
{

}

void Menu::init()
{

}

void Menu::main(N5110 &lcd, Gamepad &pad)
{
  // while not playing then main menu will display //
  play = false;
  while (play == false) {
    lcd.clear();
    lcd.printString("NEW GAME(X)", 10, 1);
    lcd.printString("GAME INFO(Y)", 10, 2);
    lcd.printString("CREDITS(B)", 10, 3);
    lcd.refresh();
    newGame(lcd,pad);
    wait_ms(1000/60);
  }

}

void Menu::newGame(N5110 &lcd, Gamepad &pad){
  // different path dependent on button press //
  // (so either new game, info or credits) //
  if (pad.check_event(Gamepad::X_PRESSED) == true){
    play = true;
  } else if (pad.check_event(Gamepad::Y_PRESSED) == true){
      info(lcd,pad);
  } else if(pad.check_event(Gamepad::B_PRESSED) == true){
      credits(lcd,pad);
  } else {
      play = false;
  }
}

void Menu::info(N5110 &lcd, Gamepad &pad)
{
  // stays in menu until L is pressed //
  while (pad.check_event(Gamepad::L_PRESSED) == false){
    lcd.clear();
    lcd.printString("MOVE(J-STICK)", 5, 1);
    lcd.printString("10 HEALTH", 15, 2);
    lcd.printString("COLLECT COINS", 5, 3);
    lcd.printString("BACK(L)", 20, 4);
    lcd.refresh();
    // corrects error with pressing button that was unused //
    // which would have an effect when returning to main menu //
    if (pad.check_event(Gamepad::X_PRESSED) == true){
    }
    if (pad.check_event(Gamepad::Y_PRESSED) == true){
    }
    if (pad.check_event(Gamepad::B_PRESSED) == true){
    }
  }
}

void Menu::credits(N5110 &lcd, Gamepad &pad)
{
  // stays in menu until L is pressed //
  while (pad.check_event(Gamepad::L_PRESSED) == false){
    lcd.clear();
    lcd.printString("CREATED BY", 10, 1);
    lcd.printString("SPENCER", 20, 2);
    lcd.printString("TINGLE", 20, 3);
    lcd.printString("BACK(L)", 20, 4);
    lcd.refresh();
    // corrects error with pressing button that was unused //
    // which would have an effect when returning to main menu //
    if (pad.check_event(Gamepad::X_PRESSED) == true){
      pad.check_event(Gamepad::L_PRESSED) == false;
    }
    if (pad.check_event(Gamepad::Y_PRESSED) == true){
      pad.check_event(Gamepad::L_PRESSED) == false;
    }
    if (pad.check_event(Gamepad::B_PRESSED) == true){
      pad.check_event(Gamepad::L_PRESSED) == false;
    }
  }
}