#include "Game.h"

Game::Game()
{
    
}

Game::~Game()
{

}

void Game::init()
{
  // set character coordinates and health //
  baby.init(x, y);
  _health = 10;

  // initialise all coin coordinates //
  coin1.init(41, 42);
  coin2.init(41, 23);
  coin3.init(78, 42);
  coin4.init(22, 34);
  coin5.init(22, 12);
  coin6.init(59, 12);
  coin7.init(59, 34);
  coin8.init(78, 14);
  coin9.init(78, 4);
  coin10.init(41, 4);
  coin11.init(4, 4);
  coin12.init(78, 23);
  coin13.init(13, 14);

  // initialise all enemy coordinates //
  enemyA.init(28, 18);
  enemy1.init(58, 31);
  enemyB.init(67, 20);
  enemy2.init(67, 12);
  enemyC.init(1, 1);  
  
  // Reset incrementers //
  enemyA.resetIncrementer();
  enemy1.resetIncrementer();
  enemyB.resetIncrementer();
  enemy2.resetIncrementer();
  enemyC.resetIncrementer();
}

int Game::get_health()
{
  return _health;
}

void Game::direc(Gamepad &pad)
{
  dir = pad.get_direction();
}

void Game::display_health(N5110 &lcd)
{
  // displays updating health value on screen //
  char buffer[14];
  sprintf(buffer,"%d",_health);
  lcd.printString(buffer,0,5);
}

void Game::drawSprite(N5110 &lcd)
{
  // draws maze //
  maze.drawSprite(lcd);
  
  // draws all coins //
  coin1.drawSprite(lcd);
  coin2.drawSprite(lcd);
  coin3.drawSprite(lcd);
  coin4.drawSprite(lcd);
  coin5.drawSprite(lcd);
  coin6.drawSprite(lcd);
  coin7.drawSprite(lcd);
  coin8.drawSprite(lcd);
  coin9.drawSprite(lcd);
  coin10.drawSprite(lcd);
  coin11.drawSprite(lcd);
  coin12.drawSprite(lcd);
  coin13.drawSprite(lcd);
  
  // draws all enemies //
  enemyA.drawSpriteA(lcd);
  enemy1.drawSprite1(lcd);
  enemyB.drawSpriteB(lcd);
  enemy2.drawSprite2(lcd);
  enemyC.drawSpriteC(lcd);

  baby.drawSprite(lcd);
}

void Game::movement(N5110 &lcd, Gamepad &pad)
{
  // all sprite movement //
  baby.movement(dir, lcd);
  enemyA.movementA(lcd);
  enemy1.movement1(lcd);
  enemyB.movementB(lcd);
  enemy2.movement2(lcd);
  enemyC.movementC(lcd);
}

void Game::collect(N5110 &lcd, Gamepad &pad)
{
  // detects whether the coin needs to be respawned //
  int x = baby.get_x_char();
  int y = baby.get_y_char();
  coin1.spawn(x, y, lcd, pad);
  coin2.spawn(x, y, lcd, pad);
  coin3.spawn(x, y, lcd, pad);
  coin4.spawn(x, y, lcd, pad);
  coin5.spawn(x, y, lcd, pad);   
  coin6.spawn(x, y, lcd, pad);
  coin7.spawn(x, y, lcd, pad);
  coin8.spawn(x, y, lcd, pad);
  coin9.spawn(x, y, lcd, pad);
  coin10.spawn(x, y, lcd, pad);
  coin11.spawn(x, y, lcd, pad);
  coin12.spawn(x, y, lcd, pad);   
  coin13.spawn(x, y, lcd, pad);
  
}

void Game::win(N5110 &lcd)
{
  // detects a win and displays win screen //
  if (coin == 1) {
    lcd.clear();
    lcd.printString("YOU",30,2);
    lcd.printString("WIN",30,3);
    lcd.printString(":)",30,3);
    lcd.refresh();
    wait(2);
  }
}

void Game::damage(N5110 &lcd, Gamepad &pad)
{
  // if collision with enemy detected -1 live //
  int x = baby.get_x_char();
  int y = baby.get_y_char();
  if (enemyA.collidePlayer(x, y, pad) == true ||
      enemy1.collidePlayer(x, y, pad) == true ||
      enemyB.collidePlayer(x, y, pad) == true ||
      enemy2.collidePlayer(x, y, pad) == true ||
      enemyC.collidePlayer(x, y, pad) == true) {
    _health--;
    wait(0.1);
  }
}

void Game::death(N5110 &lcd)
{
  // detects a loss and displays game over screen //
  if (_health == 0) {
    lcd.clear();
    lcd.printString("PUT",30,1);
    lcd.printString("ON",30,2);
    lcd.printString("TIMEOUT",30,3);
    lcd.printString(":(",30,4);
    lcd.refresh();
    wait(2);
  }
}

void Game::UI(N5110 &lcd, Gamepad &pad)
{
  // function to call on main menu in main //
  menu.main(lcd,pad);   
}