#ifndef ENEMY1_H
#define ENEMY1_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

const int enemy_A[7][7] = {
  {0,0,1,1,1,1,1},
  {0,0,0,0,0,0,1},
  {0,0,0,0,0,0,1},
  {1,1,1,1,1,1,1},
  {1,0,0,0,0,0,1},
  {1,0,0,0,0,0,1},
  {1,1,1,1,1,1,1}

  };

const int enemy_1[7][7] = {
  {1,1,1,1,0,0,0},
  {0,0,0,1,0,0,0},
  {0,0,0,1,0,0,0},
  {0,0,0,1,0,0,0},
  {0,0,0,1,0,0,0},
  {0,0,0,1,0,0,0},
  {1,1,1,1,1,1,1}

  };

/** Enemy1 class

@brief Class of Enemy1

@version 1.0

@author Spencer Tingle

@date 09/05/19

*/

class Enemy1{

 public:

  Enemy1();
  ~Enemy1();
  /** 
  * @brief Init
  * @param x, y @details Initiates coordinates of coins
  */
  void init(int x,int y);
  /** 
  * @brief Incrementer Reset
  * @details Resets incrementer used for enemy movement
  */
  void resetIncrementer();
  /** 
  * @brief Get x
  * @details Gets the current x-coordinate
  */
  int get_x_enem();
  /** 
  * @brief Get y
  * @details Gets the current y-coordinate
  */
  int get_y_enem();
  /** 
  * @brief Draw enemyA
  * @param lcd @details Draws the enemyA sprite
  */
  void drawSpriteA(N5110 &lcd);
  /** 
  * @brief Draw enemy1
  * @param lcd @details Draws the enemy1 sprite
  */
  void drawSprite1(N5110 &lcd);
  /** 
  * @brief Moves enemyA
  * @param lcd @details Moves the enemyA sprite
  */
  void movementA(N5110 &lcd);
  /** 
  * @brief Moves enemy1
  * @param lcd @details Moves the enemy1 sprite
  */
  void movement1(N5110 &lcd);
  /** 
  * @brief Detects collision
  * @param x, y, pad @details When baby and enemy collide tone plays
  */
  bool collidePlayer(int x, int y, Gamepad &pad);

 private:

  int x_enem;
  int y_enem;
  int accel;
  int _incrementer_enem1;

};

#endif