#include "Coin.h"

Coin::Coin()
{
  coin = 0;
  _spawn = true;
}

Coin::~Coin()
{

}

void Coin::init(int x, int y)
{
  x_coin = x;
  y_coin = y;
}

int Coin::get_x_coin()
{
  return x_coin;
}

int Coin::get_y_coin()
{
  return y_coin;
}

// gets current number of coins collected //
int Coin::get_coins()
{
  return coin;
}

void Coin::drawSprite(N5110 &lcd)
{
  lcd.drawSprite(x_coin,y_coin,2,2,(int *)coin_01);
}

bool Coin::collidePlayer(int x, int y, Gamepad &pad)
{
  // detects for all x and y values whether the hitboxes of the coin //
  // and controllable character collide //
  for (int ix = 0; ix < 7; ix++) {
    for (int iy = 0; iy < 7; iy++) {
      if ( x + ix == x_coin - 1 && y + iy == y_coin) {
        pad.tone(650,0.25);
        return true; 
      } else if ( x + ix == x_coin + 2 && y + iy == y_coin) {
          pad.tone(650,0.25);
          return true; 
      } else if ( x + ix == x_coin && y + iy == y_coin - 1) {
          pad.tone(650,0.25);
          return true; 
      } else if ( x + ix == x_coin && y + iy == y_coin + 2) {
          pad.tone(650,0.25);
          return true;
      }
    }
  }
  return false;
}

void Coin::spawn(int x, int y, N5110 &lcd, Gamepad &pad)
{
  // if collision true the increment coin value //
  // and move the sprite off screen //
  drawSprite(lcd);
  if (collidePlayer(x,y,pad) == true) {
    x_coin = 100;
    y_coin = 100;
    coin++;
  }
}