#ifndef BABY_H
#define BABY_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

const int sprite_01[7][7] = {
  {0,0,1,1,0,0,0},
  {0,0,0,1,0,0,0},
  {1,0,0,0,0,0,1},
  {1,0,1,0,1,0,1},
  {1,0,1,0,1,0,1},
  {1,0,0,0,0,0,1},
  {1,1,1,1,1,1,1}

  };

/** Baby class

@brief Class of the controllable player

@version 1.0

@author Spencer Tingle

@date 09/05/19

*/

class Baby{

 public:

  Baby();
  ~Baby();
  /** 
  * @brief Init
  * @param x, y @details Initiates coordinates of baby
  */
  void init(int x,int y);
  /** 
  * @brief Get x
  * @details Gets the baby's current x-coordinate
  */
  int get_x_char();
  /** 
  * @brief Get y
  * @details Gets the baby's current y-coordinate
  */
  int get_y_char();
  /** 
  * @brief Draw baby
  * @param lcd @details Draws the baby sprite
  */
  void drawSprite(N5110 &lcd);
  /** 
  * @brief Moves baby
  * @param dir, lcd @details Moves the baby sprite
  */
  void movement(Direction dir, N5110 &lcd);
  /** 
  * @brief North collsision
  * @param x, y, lcd @details Detects if baby sprite is colliding on north side
  */
  bool northCollision(int x, int y, N5110 &lcd);
  /** 
  * @brief South collsision
  * @param x, y, lcd @details Detects if baby sprite is colliding on south side
  */
  bool southCollision(int x, int y, N5110 &lcd);
  /** 
  * @brief East collsision
  * @param x, y, lcd @details Detects if baby sprite is colliding on east side
  */
  bool eastCollision(int x, int y, N5110 &lcd);
  /** 
  * @brief West collsision
  * @param x, y, lcd @details Detects if baby sprite is colliding on west side
  */
  bool westCollision(int x, int y, N5110 &lcd);
    
 private:

  int x_char;
  int y_char;
  int accel;
     
};
    
#endif