#ifndef MINIGAME_H
#define MINIGAME_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Background.h"
#include "MiniEnemy.h"
#include "Beam.h"
#include "Spacecraft.h"

#define GAP 2

/** GameEngine Class
 * @brief  The game engine for the game
 * @author Rex Roshan Raj
 */
class MiniGame
{

public:

    /** Constructor */
    MiniGame();
    
    /** Destructor */
    ~MiniGame();
    
    /** Initialises the parameters
    * @param spacecraft x pos
    * @param spacecraft y pos
    * @param beam_size
    */
    void init(int spacecraft_xpos,int spacecraft_ypos,int beam_size,int u_cloudx, int u_cloudy, int l_cloudx, int l_cloudy);
    
    /** Read the input 
    * @param Gamepad pad
    * @brief Reads the input from the Gamepad
    */
    void read_input(Gamepad &pad);
    
    /** Draws objects in minigame
    * @param N5110 lcd
    * @brief Draws the characters and the beams involved in the minigame
    */
    void draw_minigame(Gamepad &pad,N5110 &lcd);
    
    /** Updates minigame
    * @param Gamepad pad
    * @param N5110 lcd
    */
    void update_minigame(Gamepad &pad,N5110 &lcd);
    
    /** Draws the score
    * @param N5110 lcd
    * @brief Outputs the score obtained by the player
    */
    void draw_score(N5110 &lcd);
    
    /** Gets the game stage
    * @brief Gets the current stage of the game
    * @return stage
    */
    int get_game_stage();
    
private:

    void check_cloud_wall_collision(Gamepad &pad); // check if the background has collided with the wall
    void check_wall_collision(Gamepad &pad);       // check if the enemy has collided with the wall
    void check_player_collision(Gamepad &pad);     // Check if the player has collided with the enemy
    void check_enemy_collisions(Gamepad &pad);     // check if the player spacecraft beam collided with the enemy in minigame
    void enemy_dead(N5110 &lcd,Gamepad &pad);      // check if enemy spacecraft is dead
    void spacecraft_dead(N5110 &lcd,Gamepad &pad); // check if the player spacecraft is dead
    void check_playerbeam_collision(Gamepad &pad); // check if the player's spacecraft beam collided with the wall
    
    void add_speed();          // adds the speed
    void add_counter();        // adds the counter
    
    void draw_kills(N5110 &lcd);    // draws the number of kills
    
    int _spacecraft_xpos; // x position of the spacecrafts
    int _spacecraft_ypos; // y position of the spacecrafts
    
    int _u_cloudx; 
    int _u_cloudy;
    
    int _l_cloudx; 
    int _l_cloudy;
     
    int _p1x;
    int get_counter();    // value of the counter
    int _counter;       
    int set_counter();
     
    Beam _beam;      // Player beam
    
    int _beam_size;  // beam size in minigame
    
    Direction _d;
    float _mag;
    
    bool  _L;
    bool  _R;
    bool  spacebeam;
    bool  score;
    
    
    Spacecraft _p1;  // player spacecraft
    MiniEnemy  _e1;  // Minigame enemy  
    Background _b1;  // Background  
    
    int _stage;
    int _score;
    
};

#endif    