#ifndef ENEMYBOSS_H
#define ENEMYBOSS_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Enemy.h"

/** EnemyBoss Class
 * @brief  Enemies for stage three
 * @author Rex Roshan Raj
 */
class EnemyBoss
{

public:

    /** Constructor */
    EnemyBoss();
    
    /** Destructor */
    ~EnemyBoss();
    
     /** Initialise the parameters for the enemies in stage three 
    *@param a - x position of the boss
    *@param b - y position of the boss
    *@param c - x position of the first enemy
    *@param d - y position of the first enemy
    *@param e - x position of the second enemy
    *@param f - y position of the second enemy
    *@param speed - the speed of the boss moving
    */
    void init(int a,int b,int c,int d,int e,int f, int speed);
    
    /** Draws enemy
    * @param N5110 lcd
    * @brief Draws all three enemies in stage three
    */
    void enemyboss(N5110 &lcd);
    
    /** Updates the movement 
    * @brief Changes the movement of the enemy  
    */ 
    void update();
    
    /** Adds the value of health by 1 
    *@brief Health for the boss
    */
    void add_health_boss();
    
    /** Adds the value of health by 1 
    *@brief Health for the first enemy
    */
    void add_health_enemy1();
    
    /** Adds the value of health by 1 
    *@brief Health for the second enemy 
    */
    void add_health_enemy2();
    
    /** Gets the value of the health 
    * @brief returns the health of the boss
    * @returns value in range 0 to 10
    */
    int  get_health_boss();
    
    /** Gets the value of the health 
    * @brief returns the health of the first enemy
    * @returns value in range 0 to 10
    */
    int  get_health_enemy1();
    
    /** Gets the value of the health 
    * @brief returns the health of the second enemy
    * @returns value in range 0 to 10
    */
    int  get_health_enemy2();
    
    /** Sets the movement of the enemy 
    *   @param movement 
    */
    void set_movement(Vector2D m);
    
    /** Sets the position of the enemy
    *   @brief Position of the boss  
    *   @param position 
    */
    void set_enemyboss_pos(Vector2D e);
    
    /** Sets the position of the enemy 
    *   @brief Position of the first enemy 
    *   @param position 
    */
    void set_enemy1_pos(Vector2D d);
    
    /** Sets the position of the enemy 
    *   @brief Position of the second enemy 
    *   @param position
    */
    void set_enemy2_pos(Vector2D c);
    
    /** Gets the motion of the boss
    * @returns a struct with x,y members which corresponds to velocity in the x and y direction respectively
    */
    Vector2D motion();
    
    /** Gets the position of the enemy
    * @brief Position of the boss 
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_enemyboss_pos();
    
    /** Gets the position of the enemy
    * @brief Position of the first enemy
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_enemy1_pos();
    
    /** Gets the position of the enemy
    * @brief Position of the second enemy 
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_enemy2_pos();
    
    /** Gets the movement of the boss 
    * @returns a struct with x,y members which corresponds to x and y movement respectively
    */
    Vector2D get_movement();
    
private:
   
    Vector2D _movement;
    int _a;
    int _b;
    int _c;
    int _d;
    int _e;
    int _f;
    int _direction;
    int _speed;
    int _health;
    int _health1;
    int _health2;

};

#endif
