#ifndef ENEMY22_H
#define ENEMY22_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


/** Enemy22 Class
 * @brief  Second enemy for stage two
 * @author Rex Roshan Raj
 */
class Enemy22
{

public:

    /** Constructor */
    Enemy22();
    
    /** Destructor */
    ~Enemy22();
    
    /** Initialise the parameters for the second enemy in stage two 
    *@param a - x position of the enemy
    *@param b - y position of the enemy
    *@param speed - the speed of the enemy moving
    */
    void init(int a,int b,int speed);
    
    /** Draws enemy
    * @param N5110 lcd
    * @brief Draws the second enemy in stage two
    */
    void enemy2(N5110 &lcd);
    
    /** Updates the movement 
    * @brief Changes the movement of the enemy  
    */ 
    void update();
    
    /** Adds the value of health by 1 */
    void add_health();
    
    /** Sets the movement of the enemy 
    *   @param movement 
    */
    void set_movement(Vector2D m);
    
    /** Sets the position of the enemy 
    *   @param position of the enemy 
    */
    void set_enemy22_pos(Vector2D e);
    
    /** Gets the value of the health 
    * @returns value in range 0 to 10
    */
    int get_health();
    
    /** Gets the position of the enemy
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_enemy22_pos();
    
    /** Gets the movement of the enemy
    * @returns a struct with x,y members which corresponds to x and y movement respectively
    */
    Vector2D get_movement();
    
private:
   
    Vector2D _movement;
    int _a;
    int _b;
    int _c;
    int _speed;
    int _health;

};

#endif