#ifndef PIPES_H
#define PIPES_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
/** Pipes Class
@brief Class for generating and drawing pipes 
@author Rafeh Ishtiaq
@date May 2019
*/

class Pipes {
    public:
    /** Constructor */
    Pipes();
    /** Destructor */
    ~Pipes();
    /** Initialises  the x position and height of the pipes
    @param x @details The horizontal coordinate of the pipes
    @param height @details The height of the top pipe (in pixels)
    */ 
    void init(int x, int height);
    
    /** Draws the pipes on the lcd
    */
    void draw(N5110 &lcd);
    /** Generates a height for the top pipe
    @returns Random height in pixels (an integer between 1 and 25)
    */
    int generate_height();

private:

int _x;
int _height;
int _random_height;
};













#endif