#ifndef BIRD_H
#define BIRD_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
  /** Bird Class
    @brief Class to control the movement of the bird 
    @author Rafeh Ishtiaq
    @date May 2019
    */
class Bird {
  
    public:
    /** Constructor */
    Bird();
    /** Destructor */
    ~Bird();
    /** initialises and sets the horizonal and verical position of the bird
    @param xpos @details Horizonal position of the bird
    @param ypos @details vertical position of the bird
    */
    void init(int xpos, int ypos);
    /** Draws the bird on the lcd
    */
    void draw(N5110 &lcd);
    /** Gets the updated vertical positon of the bird
    @param y @details the old vertical position of the bird
    @returns y @details new vertical position of the bird (depends on button being pressed on Gamepad)
    */
    int get_position(int y, Gamepad &pad);
    
    private:
    
    int _xpos;
    int _ypos;
    int _y;
    
    
    };
#endif