#ifndef SCORING_H
#define SCORING_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
/** Scoring Class
    @brief Class for counting,updating and checking scores
    @author Rafeh Ishtiaq
    @date May 2019
    */
class Scoring {
    
    public:
    /** Constructor */
    Scoring();
    /** Destructor */
    ~Scoring();
    
    /** Sets the score
    @param score 
    */
    void set_score(int score);
    /** Displays the score and high score after the player has lost
        */
    void display_score(N5110 &lcd, Gamepad &pad);
    
    /** Boolean function to check weather the score is higher or lower than the high score
    @param highscore @details The existing high score which is compared to the recent score to check for high score
    */
    bool check_for_highscore(int score,int highscore);
    /** updates the Highscore
    @param highscore @details The current high score
    */
    void update_highscore(int highscore);
    /** Adds to the score if conditions are met 
    @param score @details The existing score
    @param pipe_x @details X coordinate of the pipes
    @param bird_x @details X coordinate of the position of the bird
    @param pipe_width @details Width of the pipe
    @returns The new score
    */
    int add_score(int score, int pipe_x,int bird_x,int pipe_width);
    
    /** Checks for the collision between the bird and the pipes by checking for overlaps
    @param bir_y @details Y coordinate of the position of the bird
    @param pipe_x @details X coordinate of the pipes
    @param pipe_height @details Height of the top pipe 
    */
    bool check_collisions(int bird_y, int pipe_x, int pipe_height);
    
    private:
    
    int _score;
    int _highscore;
    

    };









#endif