/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Rafeh Ishtiaq
Username: el17ri
Student ID Number: 201062291
Date: 20/03/2019
*/

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Pipes.h"
#include "Bird.h"
#include "Entrance.h"
#include "Scoring.h"
#define PIPE_WIDTH 8
#define BIRD_X 25
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Bird bird;
Pipes pipes;
Entrance entrance;
Scoring flappy;

/////////////////////////////Funcions////////////////////////////////////////////
void init();
void produce(int pipex1, int pipex2,int pipeheight1,int pipeheight2,int birdx,int birdy);
void print_score(int scored_points);
/////////////////////////////////////////////////////////////////////////////

int main() {
   init();
   if (pad.check_event(Gamepad::START_PRESSED) == false) {
       lcd.clear();
       
 ///////////////////////// Initialising Values//////////////////////////////////////////////////// 
       int bird_y=20;     //y position of the bird     
       int xvalue=84;   //initialising the x value of the first pipe (there will be two pipes on screen)
       int xvalue2=0;   //initialising the x value of the second pipe
       int height = pipes.generate_height(); //initialising the height of the first pipe (top part of the pipe)
       int height2=0; //initialising the height of the second pipe (top part)
    int score = 0; //initialising the score
    int highscore = 0; //initialising the highscore

  ///////////////////////////////////////////////////////////////////////////////////////////////////////
   while(1) {
       
      produce(xvalue,xvalue2,height,height2,BIRD_X,bird_y); //draw the pipes and the bird
      print_score(score); //display the score on the top right
        
        flappy.set_score(score);
         score=flappy.add_score(score,xvalue,BIRD_X,PIPE_WIDTH); //add score if the pipe has gone further left of the bird
         score=flappy.add_score(score,xvalue2,BIRD_X,PIPE_WIDTH); //check for both pipes

         if(xvalue<29 && xvalue >27) {   //generates a new pipe if the previous pipe has crossed a certain point
          height2=pipes.generate_height();   //a new height is generated for the new pipe (i.e. the placement of the gap is different)
          xvalue2=84;
          }
     if(xvalue2<29 && xvalue2>27) {        //does the same as above for the second pipe
          height=pipes.generate_height();
          xvalue=84;
          }                 
                    
       wait(0.075);
       bird_y=bird.get_position(bird_y,pad); //gets the new vertical position for the bird
       if(xvalue>2) {
       xvalue=xvalue-2; //moves the first pipes towards the left
       }
       if(xvalue2>2) {
       xvalue2=xvalue2-2; //moves the second pipe towards the left
       }
if ((flappy.check_collisions(bird_y,xvalue,height))||(flappy.check_collisions(bird_y,xvalue2,height2))) { //checking for collisions 
       wait(1);                                                                                         // between the bird and both the pipes
       
       if (flappy.check_for_highscore(score,highscore)) {    //check if the score was highscore
           highscore=score;} 
        flappy.update_highscore(highscore);    //update the highscore
        flappy.display_score(lcd,pad);
        wait(0.1);
      while (pad.check_event(Gamepad::A_PRESSED) == false) {
       lcd.clear();
       flappy.display_score(lcd,pad);      //display the score and highscore until button A is pressed
       if(pad.check_event(Gamepad::START_PRESSED) == false) { break;}
       }
       score=0;   //initialising the values again for the new game
       xvalue=84;
       bird_y=20;
       xvalue2=0;
       lcd.refresh();
       }
   lcd.refresh();
   lcd.clear();
   }
       }
       }




     void init() {
    lcd.init();
    pad.init();
    lcd.clear();
    lcd.setContrast(0.5);
   entrance.welcome_page(lcd,pad); //display the welcome page
   }
    



void produce(int pipex1, int pipex2,int pipeheight1,int pipeheight2,int birdx,int birdy){
    lcd.drawRect(0,45,84,3,FILL_BLACK); //draw the floor
    if(pipex1>2) {
      pipes.init(pipex1,pipeheight1); // draw the first pipes
      pipes.draw(lcd); 
      }
      if(pipex2>2){                    //draw the second pipe
      pipes.init(pipex2,pipeheight2);
      pipes.draw(lcd); 
      }
      bird.init(birdx,birdy); //draw the bird
      bird.draw(lcd);
      }

      
          
void print_score(int scored_points) { //displays the score when the game is being played
    char display[3];
    sprintf(display,"%d",scored_points); 
      lcd.printString(display,60,0);
      }
      
 
