#ifndef TANKENGINE_H
#define TANKENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "MainTank.h"
#include "Rocket.h" 

/** TankEngine Class
 * @brief Set and update the engine of game(include rocket and tank)
 * @author Pengxi Huang
 * @date may,2019
 */
class TankEngine
{
public:
    /** Constructor */
    TankEngine();
    /** Destructor */
    ~TankEngine();
    /** Inital the every value
     * @param the all value of the class(int)
     */
    void init();
    /** Set the Value of direction and magnitude
     * @param the value of the new position(Vector2D)
     */
    void read_input(Gamepad &pad);
    /** Set the new position and do collaps detect
     * @param the value of the new position(Vector2D)
     */
    void update(Gamepad &pad);
    /// accessors and mutators
    void Draw(N5110 &lcd);
    /** Get the life
     * @return the current life
     */
    int get_life();
    /** Get the score
     * @return the current score
     */
    int hello_score();
private:

    void HitBottom(Gamepad &pad);
    void HitTank(Gamepad &pad);
    void check_goal(Gamepad &pad);
    void print_scores(N5110 &lcd);

    
    
    MainTank _mt;
    Rocket _r;
        
    int _speed;
    int _mtx;
    int _mty;
    int _dir;
    
    Direction _d;
    float _mag;
    
};

#endif