#ifndef ROCKET_H
#define ROCKET_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Rocket Class
* @brief Set and update the value of rocket in the game
* @author Pengxi Huang
* @date may,2019
*/

class Rocket
{
public:
    /** Constructor */
    Rocket();
    /** Destructor */
    ~Rocket();
    /** Inital the postion
     * @param the X and y of the class(int)
     */
    void init();
    void draw(N5110 &lcd);
    /** Set the new position
     * @param the value of the new position(Vector2D)
     */
    void update();
    /** Get the position of rocket 1
     * @return the current poition in 2d
     */
    Vector2D get_pos1();
    /** Get the position of rocket 2
     * @return the current poition in 2d
     */
    Vector2D get_pos2();
private:
    int m_speed;
    int m_x1;
    int m_x2;
    int m_y;
};

#endif