#include "MainTank.h"




/** Constructor */
MainTank::MainTank()
{

}
/** Destructor */
MainTank::~MainTank()
{

}

/** Inital the every value
 * @param the all value of the class(int)
 */
//init the postion, score and life of the tank
void MainTank::init()
{
    m_x = 29;  // y is the initial horizontal position of tank
    m_y = 40;  // y is the fixed height of tank
    m_speed = 1; // speed for tank moving
    m_score = 0; // start score from zero
    m_life = 5;//palyer got 5 lifes

}


//draw the basic shape of tank from it's position
void MainTank::draw(N5110 &lcd)
{
    lcd.drawRect(m_x - 2, m_y - 2,5,5, FILL_BLACK);
    lcd.drawRect(m_x - 4, m_y - 5,2,11, FILL_BLACK);
    lcd.drawRect(m_x + 3, m_y - 5,2,11, FILL_BLACK);
    lcd.drawLine(m_x,m_y,m_x,m_y - 6,1);
}

/** Set the new position
 * @param the value of the new position(Vector2D)
 */
//update the new position of tank base on joystick move
void MainTank::update(Direction d,float mag)
{
    m_speed = int(mag*8.0f);  // the movemnet of joystick is too small and make it bigger to help tank move

    // update x value depending on joystick's direction
    // West is decrement as origin and it should move left.
    // east is ncrement as origin and it should move right.
    if (d == W) {
        m_x-=m_speed;
    } else if (d == E) {
        m_x+=m_speed;
    }

    // check the x origin to ensure that the tank stay in screen
    if (m_x < 5) {
        m_x = 5;
    }
    if (m_x > 54) {
        m_x = 54;
    }
}

/** Add the score
 * @param the value of the score (int)
 */
//add 1 to score
void MainTank::add_score()
{
    m_score++;
}

/** Get the score
 * @return the current score
 */
//return current score amount
int MainTank::get_score()
{
    return m_score;
}

/** Minus the life
 * @param the value of the life (int)
 */
//minus 1 to score
void MainTank::lose_life()
{
    m_life--;
}

/** Get the remain life
 * @return the life amount
 */
//return current life amount
int MainTank::remain_life()
{
    return m_life;
}

/** Get the position
 * @return the current poition in 2d
 */
//get the 2d position of tank
Vector2D MainTank::get_pos() 
{
    Vector2D p = {m_x,m_y};
    return p;    
}
