#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "MainTank.h"
#include "TankEngine.h"

/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name:Pengxi Huang
Username:Pengxi Huang
Student ID Number:201199000
Date:11.05.2019
*/

/////////////// structs /////////////////
struct UserInput {
    Direction d;
    float mag;
};

///////////// prototypes ///////////////
void init();
void update_game(UserInput input);
void render();
void welcome();
void end_game(int score);
void print_level();
int quite();

/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);  
Gamepad pad;
TankEngine Tank;
///////////// functions ////////////////
//main function
int main()
{
    int fps = 6;//frame per second
    int life = 0;
    int score = 0;
    wait(1.0f/fps);
    
    //game loop
    while(1){
        init();//init everthing 
        welcome();//print the starting menu
        render();//draw the inital image 
        while(1) {
            Tank.read_input(pad);
            Tank.update(pad);
            render();
            life = Tank.get_life();
            score = Tank.hello_score();
            
            wait(1.0f/fps);
            if (quite() == 1)//quite to starting menu if back been pressed
            {
                break;
            }
            if (life == 0)//if lose print end menu and start again
            {
                init();
                end_game(score);
                wait(3);
                break;
            }
        }
    }
}

//init everthing that needs in the game
void init()
{
    //initialise LCD and Gamepad 
    lcd.init();
    pad.init();
    lcd.setContrast(0.5);
     
    // initialise the tank to start the game
    Tank.init();

}

//update the tank iamge in the lcd
void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();  
    Tank.Draw(lcd);
    lcd.refresh();
}

//start menu with game name
void welcome() 
{
    lcd.printString("Escape  rocket    ",0,1); 
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 }
 
  // signal of quiting to start menu whenever the back is pressed
 int quite()
 {
    int quite = 0;
    //vheck the status od back button
    while ( pad.check_event(Gamepad::BACK_PRESSED) == true) {
        quite = 1;
    }
    return quite;
 }
 
 // end menu when palyer lost all life in the game  
 void end_game(int score)
 {
    char buffer1[13];
    sprintf(buffer1,"%2d",score);
    lcd.printString("   Good Game    ",0,1); 
    lcd.printString("  Final score is ",0,3);
    //print its final score
    lcd.printString(buffer1,35,4);
    lcd.refresh();
 }
 