#include "TankEngine.h"




TankEngine::TankEngine()
{

}

TankEngine::~TankEngine()
{

}

//init value of tank and rocket
void TankEngine::init()
{
    _mt.init();
    _r.init();
}


//get the input value from gamepad
void TankEngine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();//read joystick direction
    _mag = pad.get_mag();//read joystick movement
}


//update the status of tank and rocket
void TankEngine::update(Gamepad &pad)
{ 
    _mt.update(_d,_mag);
    _r.update();
    HitBottom(pad);//collaps detect between rocket and window bottom.
    HitTank(pad);//collaps detect between rocket and tank
}

//collaps detect between rocket and window bottom.
void TankEngine::HitBottom(Gamepad &pad)
{
    Vector2D Rocket_pos1 = _r.get_pos1();//get position for rocket 1
    Vector2D Rocket_pos2 = _r.get_pos2();//get position for rocket 2
    if ((Rocket_pos1.y>= 45) && (Rocket_pos2.y>= 45)) {
        // hit bottom
        _r.init();//Init rocket status
        _mt.add_score();//Add score
    } 
}

//collaps detect between rocket and tank
void TankEngine::HitTank(Gamepad &pad)
{
    Vector2D Rocket_pos1 = _r.get_pos1();//get position for rocket 1
    Vector2D Rocket_pos2 = _r.get_pos2();//get position for rocket 2
    Vector2D Tank_pos = _mt.get_pos();//get position for tank
    if ((Tank_pos.y - Rocket_pos1.y <= 8) &&
        (Tank_pos.x - 4 <= Rocket_pos1.x + 2) &&
        (Tank_pos.x + 3 >= Rocket_pos1.x - 2)
      ) {
        _r.init();//Init rocket status
        _mt.lose_life();//minus life
        // audio feedback for hitting
        pad.tone(750.0,0.1);
    } else if ((Tank_pos.y - Rocket_pos2.y <= 8) &&
               (Tank_pos.x - 4 <= Rocket_pos2.x + 2) &&
               (Tank_pos.x + 3 >= Rocket_pos2.x - 2)
               ){
                _r.init();//Init rocket status
                _mt.lose_life();//minus life
                 // audio feedback for hitting
                pad.tone(750.0,0.1);
    }
}
 
//print the window and the obeject of the game
void TankEngine::Draw(N5110 &lcd)
{
    _mt.draw(lcd);
    _r.draw(lcd);
    print_scores(lcd);
    
    //draw window
    lcd.drawRect(0,0,60,48,FILL_TRANSPARENT);
    lcd.drawRect(59,0,25,48,FILL_TRANSPARENT);
    lcd.drawLine(59,24,83,24,1);
    
    //draw the letter of score
    lcd.setPixel(62,2,true);//s
    lcd.setPixel(63,2,true);
    lcd.setPixel(61,3,true);
    lcd.setPixel(62,4,true);
    lcd.setPixel(63,5,true);
    lcd.setPixel(62,6,true);
    lcd.setPixel(61,6,true);
    
    lcd.setPixel(66,2,true);//c
    lcd.setPixel(67,2,true);
    lcd.setPixel(65,3,true);
    lcd.setPixel(65,4,true);
    lcd.setPixel(65,5,true);
    lcd.setPixel(66,6,true);
    lcd.setPixel(67,6,true);
    
    lcd.setPixel(70,2,true);//o
    lcd.setPixel(69,3,true);
    lcd.setPixel(69,4,true);
    lcd.setPixel(69,5,true);
    lcd.setPixel(71,3,true);
    lcd.setPixel(71,4,true);
    lcd.setPixel(71,5,true);
    lcd.setPixel(70,6,true);
    
    lcd.drawLine(73,2,73,6,1);//R
    lcd.setPixel(74,2,true);
    lcd.setPixel(74,4,true);
    lcd.setPixel(74,5,true);
    lcd.setPixel(75,3,true);
    lcd.setPixel(75,6,true);
    
    lcd.drawLine(77,2,77,6,1);//E
    lcd.setPixel(78,2,true);
    lcd.setPixel(78,4,true);
    lcd.setPixel(78,6,true);
    lcd.setPixel(79,2,true);
    lcd.setPixel(79,4,true);
    lcd.setPixel(79,6,true);
    
    lcd.setPixel(81,3,true);//:
    lcd.setPixel(81,5,true);
    
    //draw the letter of life
    lcd.drawLine(61,26,61,30,1);//L
    lcd.setPixel(62,30,true);
    lcd.setPixel(63,30,true);
    
    lcd.drawLine(66,26,66,30,1);//I
    lcd.setPixel(65,26,true);
    lcd.setPixel(65,30,true);
    lcd.setPixel(67,26,true);
    lcd.setPixel(67,30,true);
    
    lcd.drawLine(69,26,69,30,1);//F
    lcd.setPixel(70,26,true);
    lcd.setPixel(70,28,true);
    lcd.setPixel(71,26,true);
    lcd.setPixel(71,28,true);
    
    lcd.drawLine(73,26,73,30,1);//E
    lcd.setPixel(74,26,true);
    lcd.setPixel(74,28,true);
    lcd.setPixel(74,30,true);
    lcd.setPixel(75,26,true);
    lcd.setPixel(75,28,true);
    lcd.setPixel(75,30,true);
    
    lcd.setPixel(77,27,true);
    lcd.setPixel(77,29,true);
}

//print both score and life of the tank
void TankEngine::print_scores(N5110 &lcd)
{
    int tank_score = _mt.get_score();//get palyer score
    char buffer1[14];
    sprintf(buffer1,"%2d",tank_score);

    lcd.printString(buffer1,66,1);//print player score
    
    int tank_life = _mt.remain_life();//get palyer remain Life
    char buffer2[17];
    sprintf(buffer2,"%2d",tank_life);
    
    lcd.printString(buffer2,66,4);//print palyer remain Life
    
}

//Get the value of score
int TankEngine::hello_score()
{
    int score = _mt.get_score();
    return score;
}

//Get the value of life
int TankEngine::get_life()
{
    int life =_mt.remain_life();
    return life;
}
