///////// pre-processor directives ////////
#ifndef __MAIN_TANK__
#define __MAIN_TANK__

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** MainTank Class
 * @brief Set and update the value of tank in the game
 * @author Pengxi Huang
 * @date may,2019
 */

class MainTank 
{
public:
    MainTank();
    ~MainTank();
    void update(Direction d,float mag);
    void init();
    void draw(N5110 &lcd);
    void add_score();
    int get_score();
    void lose_life();
    int remain_life();
    Vector2D get_pos();
private:
    int m_x;
    int m_y;
    int m_speed;
    int m_score;
    int m_life;
};


#endif