/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name:Nigel T.K. Vere
Username:el17ntkv
Student ID Number:201153410
Date:5/3/2019
*/



#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Badengine.h"


N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Badengine badman;


//Function prototypes for functions used for game functionality -described in more
//detail below
void init();
void render();
void welcome() ;
void mainmenu();
void levelscreen();
void gameover();
void settings();
void helppage1();
void helppage2();

bool setting = false;
bool help = false;
bool game_start = false;
int level = 1;//Integer variable used to store the current game level at a given point in time
int score = 0;//Integer variable used to store the current game score at a given point in time
float contrast=0.5;//Integer variable used to store the current LCD contrast value at a given point in time
float brightness=0.5;//Integer variable used to store the current LCD brightness value at a given point in time

int main()
{
    init();
    int fps = 7;

    welcome();
    
    
    while(game_start == false)
    {mainmenu();
    if(setting == true) {
        settings();
        setting  =false;
    }
    if(help == true) {
        helppage1();
        helppage2();
        help = false;
    }
    }

    while(badman.getGhostStatus() == true) {
        if(level>1) {
            badman.init();
        }

        levelscreen();
        badman.setGhostNumber(level);
        render();

        while (badman.getStatus() == true && badman.getGhostStatus() == true) {
            badman.readInput(pad);
            badman.update(pad);
            render();
            wait(1.0f/fps);
        }
        
        score = score + badman.getScore();
        if(badman.getGhostStatus() == true) {
            level=level+ 1;
        }
    }
    gameover();
    
}


//Mutator method initialises the game and it's respective parameters and variables
//used to actuate with the characters
void init(){
    lcd.init();
    lcd.setContrast(contrast);
    lcd.setBrightness(brightness);
    lcd.normalMode();
    pad.init();
    badman.init();

}

//Mutator method used for in-game rendering displaying the contents of the screen and game
//each time the game is updated
void render() {
    lcd.clear();
    badman.draw(lcd);
    lcd.refresh();
}

//Mutator method displays a welcome screen to the user when the game starts 
void welcome() {
    int Badnews[19][17] = {

        {0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0},
        {0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0},
        {0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0},
        {0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0},
        {1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1},
        {1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1},
        {1,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1},
        {1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1},
        {1,1,1,0,0,0,0,1,0,1,0,0,0,0,1,1,1},
        {0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,0,1,0,0,1,1,1,1,1,1,1,0,0,1,0,0},
        {0,0,1,1,0,0,1,1,1,1,1,0,0,1,1,0,0},
        {0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0},
        {0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0},
        {0,0,0,1,1,0,0,0,0,0,0,0,1,1,0,0,0},
        {0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0},



    };
    lcd.drawSprite(5,5,19,17,(int*)Badnews);
    lcd.printString("BADMAN!",35,1);
    lcd.printString("On the Run",22,2);
    lcd.printString("Start to Enter",0,4);
    lcd.refresh();

    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }

}

//Mutator method used for ingame navigation between the respective game features such
//as game start,settings and help
void mainmenu() {
    lcd.clear();
    lcd.printString("Press X:Start Game ",0,2);
    lcd.printString("Press Y:Help",0,3);
    lcd.printString("Press A:Settings",0,4);
    lcd.refresh();

    while(true) { // wait flashing LEDs until start button is pressed
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
        if ( pad.check_event(Gamepad::X_PRESSED) == true) {
            game_start = true;
            break;
        }
        if(pad.check_event(Gamepad::Y_PRESSED) == true) {
            help = true;
            break;
        }
        if(pad.check_event(Gamepad::A_PRESSED) == true) {
            setting = true;
            break;
        }
    }
}

//Mutator method triggered when the user selects the settings option from the main menu
//used to change the screens brightness and/or contrast using the potentiometer
//with the current value on the potentiometer used to update these variables when
//the user presses X for brightness and Y for Contrast
void settings() {
    lcd.clear();
    while (pad.check_event(Gamepad::START_PRESSED)==false) {

        lcd.drawRect(0,9,60,15,FILL_TRANSPARENT);
        lcd.drawRect(0,9,int(brightness*60),15,FILL_BLACK);
        lcd.drawRect(0,25,60,15,FILL_TRANSPARENT);
        lcd.drawRect(0,25,int(contrast*60),15,FILL_BLACK);

        const int brightness_sprite[15][15]= {

            {1,0,0,0,0,0,0,1,0,0,0,0,0,0,1},
            {0,1,0,0,0,0,0,1,0,0,0,0,0,1,0},
            {0,0,1,0,0,0,0,1,0,0,0,0,0,0,0},
            {0,0,0,1,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,1,0,0,1,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
            {0,0,0,0,0,1,1,1,1,1,0,0,0,0,0},
            {1,1,0,0,1,1,1,1,1,1,1,0,0,1,1},
            {0,0,0,0,0,1,1,1,1,1,0,0,0,0,0},
            {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
            {0,0,0,0,1,0,0,1,0,0,1,0,0,0,0},
            {0,0,0,1,0,0,0,0,0,0,0,1,0,0,0},
            {0,0,1,0,0,0,0,1,0,0,0,0,1,0,0},
            {0,1,0,0,0,0,0,1,0,0,0,0,0,1,0},
            {1,0,0,0,0,0,0,1,0,0,0,0,0,0,1},
        };


        const int contrast_sprite[16][16]= {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
            {1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1},
            {1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1},
            {1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1},
            {1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1},
            {1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1},
            {1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1},
            {1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1},
            {1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1},
            {1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1},
            {1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1},
            {1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1},
            {1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1},
            {1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1},
            {1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        };

        lcd.drawSprite(64,9,15,15,(int *)brightness_sprite);
        lcd.drawSprite(64,25,16,16,(int *)contrast_sprite);
        lcd.refresh();

        if(pad.check_event(Gamepad::X_PRESSED) == true) {
            brightness = pad.read_pot();
            lcd.setBrightness(brightness);
        }
        if(pad.check_event(Gamepad::B_PRESSED) == true) {
            contrast = pad.read_pot();
            lcd.setContrast(contrast);
        }
    }
}

//Mutator method that displays the current level at the beginning of each new level
//along with the current score accumulated at the point in time with no score
//displayed when ushering in level one for obvious reasons
void levelscreen() {
    lcd.clear();
    int Badnews[19][17] = {

        {0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0},
        {0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0},
        {0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0},
        {0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0},
        {1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1},
        {1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1},
        {1,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1},
        {1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1},
        {1,1,1,0,0,0,0,1,0,1,0,0,0,0,1,1,1},
        {0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,0,1,0,0,1,1,1,1,1,1,1,0,0,1,0,0},
        {0,0,1,1,0,0,1,1,1,1,1,0,0,1,1,0,0},
        {0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0},
        {0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0},
        {0,0,0,1,1,0,0,0,0,0,0,0,1,1,0,0,0},
        {0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0},

    };
    lcd.drawSprite(50,0,19,17,(int*)Badnews);

    char buffer1[14];
    sprintf(buffer1,"LEVEL %2d",level);
    lcd.printString(buffer1,0,3);
    if(level > 1) {
        sprintf(buffer1,"Score: %d",score);
        lcd.printString(buffer1,0,4);
    }
    lcd.printString("B to Start ",0,5);
    lcd.refresh();

    while ( pad.check_event(Gamepad::B_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }

}

//Mutator method used to display the gameover screen when the game ends
//which occurs when the user movement of the joystick results in a badman character-
//ghost character collision ;with the final score printed on the screen
void gameover(){
    lcd.clear();
    char buffer1[14];
    int Badnews[19][17] = {

        {0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0},
        {0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0},
        {0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0},
        {0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0},
        {1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1},
        {1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1},
        {1,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1},
        {1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1},
        {1,1,1,0,0,0,0,1,0,1,0,0,0,0,1,1,1},
        {0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,0,1,0,0,1,1,1,1,1,1,1,0,0,1,0,0},
        {0,0,1,1,0,0,1,1,1,1,1,0,0,1,1,0,0},
        {0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0},
        {0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0},
        {0,0,0,1,1,0,0,0,0,0,0,0,1,1,0,0,0},
        {0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0},

    };
    lcd.drawSprite(50,0,19,17,(int*)Badnews);
    
    sprintf(buffer1,"Score:%d",score);
    lcd.printString(buffer1,0,3);
    lcd.printString("Badman was",0,4);
    lcd.printString("caught :'(",0,5);
    lcd.refresh();

    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }

}

//Mutator method displaying the first help page on the screen seen when user selects to observe the help option
void helppage1(){
    lcd.clear();
    lcd.printString("Badman Controls:",0,1);
    lcd.printString("Use Joystick",0,3);
    lcd.printString("to move badman",0,4);
    lcd.refresh();

    while ( pad.check_event(Gamepad::A_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }

}

//Mutator method that displays the second help page on the LCD display when the user
//selects continued navigation from the first help screen
void helppage2(){
    
    lcd.clear();
    lcd.printString("Game Object:",0,1);
    lcd.printString("Dodge the ghosts",0,2);
    lcd.printString("of badman past",0,3);
    lcd.printString("Eat the fruit",0,4);
    lcd.printString("for energy",0,5);
    lcd.refresh();

    while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}


