#ifndef SCREENARRAY_H
#define SCREENARRAY_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


/** ScreenArray Class
@author Mr Nigel TK Vere, University of Leeds
@brief ScreenArray class used for collision detection and score detection within the badman game
@date April 2019
*/

/**ScreenArray Class

@brief ScreenArray class used for collision detection and score detection within the badman game

@version 1.0

@author Mr Nigel TK Vere

@date April 2019


*/
class ScreenArray
{

public:
    /** ScreenArray object donstructor */
    ScreenArray();
    /**ScreenArray object destructor */
    ~ScreenArray();
    /**
    * @brief Mutator method initialises the screenarray object by filling the integer array with zeros

    */
    void init();

    /**
    * @brief //Accessor method returns the value of the element at the array poisiton denoted by the x and y coordinates(columns and rows value) passed as the method parameter
    * @param x @details X coordinate value of the screen position whose value we wish to retrieve
    * @param y @details Y coordinate value of the screen position whose value we wish to retrieve

    */
    int get(int x,int y);

    /**@brief Mutator method sets the array element at the position denoted by the x and y coordinates(columns and rows value) to the type(integer value) passed as the method's parameters
    * @param x @details Integer X coordinate value of the screen position whose value we wish to alter
    * @param y @details Integer Y coordinate value of the screen position whose value we wish to alter
    *@param type @details Integer value denoting the type of object at this point in the grid
    */
    void set(int x,int y,int type);

    /**@brief //Mutator method sets all the elements within the region of elements within the screen array to the type passed as the method parameter call
    * @param x @details Integer X coordinate value of the screen position whose value we wish to alter
    * @param y @details Integer Y coordinate value of the screen position whose value we wish to alter
    *@param width @details Integer value denoting the width of the screen array region that needs to be altered
    *@param height @details Integer value denoting the height of the screen array region that needs to be altered
    *@param type @details Integer value denoting the type of object at this point in the grid
    */
    void setRange(int x,int y,int width,int height,int type);




private:
    int Screen[48][84];
    int screen_x;
    int screen_y;





};
#endif