#ifndef GRID_H
#define GRID_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "ScreenArray.h"
#include "Charactersprites.h"
#include "Ghost.h"
#include <vector>
#include <stdlib.h>
#include <time.h>

/** Grid Class
@author Mr Nigel TK Vere, University of Leeds
@brief Controls and models the grid or maze used in the game main character for the badman game
@date April 2019
*/

/** Grid Class

@brief Controls and models the grid or maze  used in the game main character for the badman game

@version 1.0

@author Mr Nigel TK Vere

@date April 2019


*/

class Grid
{

public:
    /** Grid object Constructor */
    Grid();
    /**Grid object Destructor */
    ~Grid();
    /** Displays the grid maze where the game takes place
    * @param lcd @details Reference Nokia 5110 LCD screen object
    * @param ghostnumber @details Integer value representing the maximum number of ghost characters that can be generated in the badman game
    */
    void drawGrid(N5110 &lcd,int ghostnumber);
    /**
    * @brief Mutator method initialises the grid object by subsequently initialising the screen array object and the number of ghosts that can be generated in the game
    * @param screen @details Reference screen array object used to initalise the screen array object used in the game
    * @param ghostnumber @details Integer value representing the maximum number of ghost characters that can be generated in the badman game

    */
    void init(ScreenArray &screen,int ghostnumber);
    /**
    * @brief Mutator method used to remove a fruit from the grid when badman eats it
    * @param x @details X coordinate of the point of impact between badman and the fruit
    * @param y @details Y coordinate of the point of impact between badman and the fruit
    * @param screen @details Reference screen array object for the removal of the fruit from the screen array object

    */
    void updateFruit(int x,int y,ScreenArray &screen);
    /**
    * @brief Mutator method used for ghost-badman collision detection
    * @param screen @details Reference screen array object for the ghost-grid collision detection
    * @param ghostnumber @details Integer value representing the number of ghosts currently observed at the current level
    * @param x @details Current x coordinate of the centre of the badman character object
    * @param y @details Current y coordinate of the centre of the badman character object
    * @param r @details Current radius(_size value)  the badman character object


    */
    bool update(ScreenArray &screen,int ghostnumber,int x,int y,int r);

    /**
    * @brief Accessor method gets the number  of the  charactersrpite objects(Fruits) currently on the screen
    @returns Returns the number  of charactersprite objects on the screen

    */
    int getFruitNumber();

    /**
    // FORMAT_CODE_START
    * @brief Mutator method used for generating fruits in the game
    // FORMAT_CODE_END
    * @param screen @details Reference screen array object for the ghost-grid collision detection



    */
    void generateFruits(ScreenArray &screen);
    /**
    * @brief Mutator method used for generating ghost characters within the grid of the game
    * @param screen @details Reference screen array object for the ghost-grid collision detection
    * @param ghostnumber @details Integer value representing the number of ghosts currently observed at the current level

    */
    void generateGhosts(ScreenArray &screen,int ghostnumber);


private:
    std::vector<Charactersprites> fruits;//Vector holds all the fruit charactersprite objects that will be used in the badman game for a respective level
    std::vector<Ghost> ghosts;//Vector holds all the ghost character objects that will be used in the badman game


};
#endif