#include "Grid.h"

//Default grid object constructor
Grid::Grid(){
}

//Default gid object destructor
Grid::~Grid(){
}

void Grid::init(ScreenArray &screen,int ghostnumber){
   
    
    for(int b = 0 ; b < 48; b++) {
        screen.set(0,b,1);
    }

    for(int a = 0; a < 84; a++) {
        screen.set(a,0,1);
    }

    for(int b = 0 ; b <48; b++) {
        screen.set(83,b,1);
    }

    for(int a = 0; a < 84; a++) {
        screen.set(a,47,1);
    }

    screen.setRange(7,7,15,7,1);
    screen.setRange(16,13,6,12,1);
    screen.setRange(7,19,3,6,1);
    screen.setRange(0,32,9,8,1);
    screen.setRange(17,32,19,4,1);
    screen.setRange(30,36,6,4,1);
    screen.setRange(15,42,6,7,1);
    screen.setRange(28,0,7,11,1);
    screen.setRange(28,17,6,9,1);
    screen.setRange(44,12,5,6,1);
    screen.setRange(50,24,4,3,1);
    screen.setRange(42,27,12,4,1);
    screen.setRange(43,38,19,3,1);
    screen.setRange(51,41,3,7,1);
    screen.setRange(44,0,6,5,1);
    screen.setRange(60,7,13,4,1);
    screen.setRange(60,11,6,12,1);
    screen.setRange(60,30,9,2,1);
    screen.setRange(73,20,10,4,1);
    screen.setRange(69,38,10,3,1);
    screen.setRange(79,31,5,17,1);

    generateFruits(screen);
    generateGhosts(screen,ghostnumber);

}

//Mutator method that takes an its input parameter a screen array referece object
//generating the fruit characters randomly within empty spaces of the screen array
//denoted by the region consisting of a series of zeros
void Grid::generateFruits(ScreenArray &screen){
    srand (time(NULL));

    int count = 0;
    while(count != 9) {
        bool addSprite = false;
        Charactersprites character = Charactersprites();
        while(addSprite == false) {

            int x = rand()%83 + 1;

            int y = rand()%47 + 1;

            int type = rand()%2 + 1;

            character.init(x,y,type);

            int overlapcount = 0;
            for(int a = character.getTopl().x - 2; a < character.getTopl().x + 5; a++) {
                for(int b = character.getTopl().y - 2  ; b < character.getTopl().y + 5; b++) {

                    if(screen.get(a,b)!= 0) {
                        overlapcount++;
                    }
                }
            }
            if(overlapcount == 0) {
                addSprite = true;
            }

            if (!(character.getTopl().x < 83 && character.getTopl().y < 47   && character.getBottl().x < 83 && character.getBottl().y < 47 && character.getTopr().x < 83 && character.getTopr().y < 47  && character.getBottr().x < 83 && character.getBottr().y < 47  ) || !(character.getTopl().x >0 && character.getTopl().y >0   && character.getBottl().x >0 && character.getBottl().y >0 && character.getTopr().x >0 && character.getTopr().y >0  && character.getBottr().x >0 && character.getBottr().y >0  )) {
                addSprite = false;
            }
            if(screen.get(character.getTopl().x,character.getTopl().y  ) !=0 &&screen.get(character.getBottl().x,character.getBottl().y ) != 0 && screen.get(character.getTopr().x,character.getTopr().y ) != 0 && screen.get(character.getBottr().x,character.getBottr().y ) != 0  ) {
                addSprite = false;
            }
        }
        if(addSprite == true) {
            fruits.push_back(character);
            screen.setRange(character.getTopl().x,character.getTopl().y,3,3,character.getValue());
            count++;
        }
    }
}


//Mutator method that takes an its input parameter a screen array reference object
//generating the ghost characters randomly within empty spaces of the screen array
//denoted by the region consisting of a series of zeros
void Grid::generateGhosts(ScreenArray &screen,int ghostnumber) {
    while(ghostnumber != 0) {
        bool addGhost = false;
        int x ;
        int y;
        Ghost ghost =  Ghost();
        while(addGhost == false) {

            x = rand()%72 + 10;
            y = rand()%36 + 10;

            ghost.init(2,x,y);

            int overlapcount =0;
            for(int a = ghost.getPos().x - 3; a < ghost.getPos().x +3; a++) {
                for(int b = ghost.getPos().y - 3  ; b < ghost.getPos().y + 3; b++) {

                    if(screen.get(a,b)!= 0) {
                        overlapcount++;
                    }
                }
            }
            if(overlapcount == 0) {
                addGhost = true;
            }
        }
        if(addGhost == true) {
            ghosts.push_back(ghost);
            ghostnumber--;
        }
    }
}


void Grid::updateFruit(int x,int y,ScreenArray &screen) {
    int index = 99;
    for(std::vector<Charactersprites>::size_type i = 0; i != fruits.size(); i++) {

        if(x >= fruits.at(i).getTopl().x && x <= fruits.at(i).getTopr().x && y >= fruits.at(i).getTopl().y && y <= fruits.at(i).getBottl().y) {
            index = i;
        }
    }
    if(index != 99) {
        screen.setRange(fruits.at(index).getTopl().x,fruits.at(index).getTopl().y,3,3,0);
        fruits.erase(fruits.begin() + index);
    }
}

//Muatator method that takes as input a LCD screen reference object and an integer
//representing the number of ghosts in the grid at that particular moment
//displaying the grid,fruit characters and ghosts characters depending on their
//particular positions within the grid
void Grid::drawGrid(N5110 &lcd,int ghostnumber) {
    lcd.drawLine(0,0,0,47,1);
    lcd.drawLine(0,0,83,0,1);
    lcd.drawLine(83,0,83,48,1);
    lcd.drawLine(0,47,83,47,1);
    lcd.drawRect(7,7,15,7,FILL_BLACK);
    lcd.drawRect(16,13,6,12,FILL_BLACK);
    lcd.drawRect(7,19,3,6,FILL_BLACK);
    lcd.drawRect(0,32,9,8,FILL_BLACK);
    lcd.drawRect(17,32,19,4,FILL_BLACK);
    lcd.drawRect(30,36,6,4,FILL_BLACK);
    lcd.drawRect(15,42,6,7,FILL_BLACK);
    lcd.drawRect(28,0,7,11,FILL_BLACK);
    lcd.drawRect(28,17,6,9,FILL_BLACK);
    lcd.drawRect(44,12,5,6,FILL_BLACK);
    lcd.drawRect(50,24,4,3,FILL_BLACK);
    lcd.drawRect(42,27,12,4,FILL_BLACK);
    lcd.drawRect(43,38,19,3,FILL_BLACK);
    lcd.drawRect(51,41,3,7,FILL_BLACK);
    lcd.drawRect(44,0,6,5,FILL_BLACK);
    lcd.drawRect(60,7,13,4,FILL_BLACK);
    lcd.drawRect(60,11,6,12,FILL_BLACK);
    lcd.drawRect(60,30,9,2,FILL_BLACK);
    lcd.drawRect(73,20,10,4,FILL_BLACK);
    lcd.drawRect(69,38,10,3,FILL_BLACK);
    lcd.drawRect(79,31,5,17,FILL_BLACK);

    for(std::vector<Charactersprites>::size_type i = 0; i != fruits.size(); i++) {
        fruits.at(i).displaySprite(lcd);
    }
    for(std::vector<Ghost>::size_type i = 0; i != ghostnumber ; i++) {
        ghosts.at(i).draw(lcd);
    }

}

//Accessor method that takes as input a reference to the screen array object used
//for collision detection within our program,the number of ghosts available within
//the maze at this point in time within the game and the centre coordinates of
//badman character and its radius for badman-ghost collision detection-
//returning true if any badman-ghost collisions have taken place and false if none have taken
//place
bool Grid::update(ScreenArray &screen,int ghostdisplay,int x,int y,int r) {
    bool value = false;
    for(std::vector<Ghost>::size_type i = 0; i != ghostdisplay ; i++) {
        ghosts.at(i).update(screen);

        if(ghosts.at(i).collisiondetection( x, y, r) == true) {
            value = true;
        }
    }
    return value;
}

//Accessor method returns the number of fruits remaining in the vector that holds the number
//of fruits remaining in the game
int Grid::getFruitNumber() {
    return fruits.size();
}




