#ifndef GHOST_H
#define GHOST_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "ScreenArray.h"
#include<cmath>


/** Ghost Class
@author Mr Nigel TK Vere, University of Leeds
@brief Controls and models the ghost  character for the badman game
@date April 2019
*/

/** Ghost Class

@brief Controls and models the ghost character for the badman game

@version 1.0

@author Mr Nigel TK Vere

@date April 2019


*/

class Ghost
{

public:

    /**
    * @brief Default Ghost object constructor

    */
    Ghost();
    /**
    * @brief Default Ghost object destructor

    */
    ~Ghost();
    /**
    * @brief Mutator method initialises the ghost character object setting it's radius and start position in the maze
    * @param size @details Integer value giving the radius of the ghost object
    * @param x @details Integer value giving the x coordinate  of the ghost object
    * @param y @details Integer value giving the y coordinate  of the ghost object
    */
    void init(int size,int x,int y);
    /**
    * @brief Mutator method displays the ghost character on the lcd screen dependent on it's current x and y coordinates and size
    * @param lcd @details Reference Nokia 5110 LCD screen object
    */
    void draw(N5110 &lcd);
    /**
    * @brief Accessor method checks whether the ghost object has collided with the badman character object
    * @param x @details Integer value giving the x coordinate  of the badman character object
    * @param y @details Integer value giving the y coordinate  of the badman character object
     * @param r @details Integer value giving the radius of the badman character object
      @returns Returns a boolean value notifying whether a ghost-badman collision has occured
    */
    bool collisiondetection(int x,int y,int r);
    /**
    * @brief Accessor method gets the current coordinates of the ghost character object
    @returns Returns the Vector data type holding the current x and y coordinates of the ghost character object's centre
    */
    Vector2D getPos();
    /**
    * @brief Mutator method updates the ghost object's movement in the instance that the ghost has collided with a wall
    * @param screen @details Reference screen array object for the ghost object collision detection
    */
    void update(ScreenArray &screen);

    /**
    * @brief Accessor method checks ghost-wall collisions
    @returns Returns an integer value notifying the type of object the ghost has collided with as it moves
    */
    int checkCollision(ScreenArray &screen);

    /**
      * @brief Mutator method gets the current x and y coordinate of the ghost object to the coordinate passed in the function call
      * @param x @details X coordinate value of the new position the ghost character object is to move to
      * @param y @details Y coordinate value of the new position the ghost character object is to move to
      */
    void setPos(int x, int y);

    /**
    * @brief Accessor method gets the size of badman character object
    @returns Returns the size(radius ) of the badman character object
    */
    int getSize();




private:
    int _x;//Integer value represents the x coordinate of the ghost character
    int _y;//Integer value represents the y coordinate of the ghost character
    int _direction;//Integer value represents the direction of movement of the ghost character
    int _size;//Integer value represents radius of the ghost character
    Vector2D _topr;
    Vector2D _bottr;
    Vector2D _bottl;
    Vector2D _topl;
};
#endif