#include "Ghost.h"

//Default Ghost object constructor
Ghost::Ghost()
{
}
//Default Ghost object destructor
Ghost::~Ghost()
{
}

//Mutator method initialises the ghost character object by setting it's initial start position
//and it's size to the value passed as the parameter in the function call and the
//ghost character's start centre coordinates to the x and y value passed in the
//method call.
void Ghost::init(int size,int x,int y)
{
    _size = size;
    _x = x;
    _y = y;
    _direction = rand()%4;

    int cleft = _x - size;
    int ctop     = _y - size;
    int cright= _x + size;
    int cbottom =  _y + size;

    _topl.x = cleft;
    _topl.y = ctop;
    _topr.x =ctop ;
    _topr.y = cright;
    _bottr.x =cbottom ;
    _bottr.y = cright;
    _bottl.x = cbottom;
    _bottl.y = cleft;


}

//Mutator method takes as a parameter a LCD reference object and displays the
//ghost character on the screen dependent on the current value of it's x and y
//coordinates
void Ghost::draw(N5110 &lcd)
{
    lcd.drawCircle(_x,_y,_size,FILL_TRANSPARENT);
    lcd.drawCircle(_x,_y,_size/2,FILL_BLACK);
}

//Accessor method checks whether the current ghost object has collided with the badman character
//object present on the screen with the badman character's current x ,y centre
// coordinates and radius passed as the method's parameters-returning true if a
//collision between the respective ghost object and the badman character object
//and false otherwise
bool Ghost::collisiondetection(int x,int y,int r)
{
    bool value = false;
    if((pow((x-_x),2.0) + pow((y-_y),2.0)) <= pow((r+_size),2.0)) {
        value = true;
    }
    return value;
}




//Accessor method return the ghost character's current x and y centre coordinates
Vector2D Ghost::getPos()
{
    Vector2D p = {_x,_y};
    return p;
}

//Mutator method takes the x and y integer values passed as the method's parameters
//and sets the ghost's objects x and y coordinates to this value
void Ghost::setPos(int x,int y)
{
    _x =x;
    _y = y;
    int cleft = _x - _size;
    int ctop     = _y - _size;
    int cright= _x + _size;
    int cbottom =  _y + _size;

    _topl.x = cleft;
    _topl.y = ctop;
    _topr.x =ctop ;
    _topr.y = cright;
    _bottr.x =cbottom ;
    _bottr.y = cright;
    _bottl.x = cbottom;
    _bottl.y = cleft;
}

//Mutator method updates the ghost object by moving it by one place in the direction of
//movement denoted by the _direction private variable every time this method is called
//changing the ghosts movement randomly if the ghost collides with a wall pixel
//denoted by the checkcollision() function returning a 1 within the maze
//making use of the principle of recursion
void Ghost::update(ScreenArray &screen)
{

    {
        //Direction is N
        if(_direction == 0 && checkCollision(screen)!=1 ) {
            _y = _y - 1;
        }
//Direction is E
        else if(_direction == 1 && checkCollision(screen)!=1) {
            _x = _x + 1;
        }
//Direction is W
        else if(_direction == 2 && checkCollision(screen)!=1) {
            _x =_x -1;
        }
//Direction is S
        else if(_direction == 3 && checkCollision(screen)!=1) {
            _y = _y + 1;
        }

        bool collision = false;
        if(checkCollision(screen) ==1) {
            collision = true;
        }

        if(collision == true) {
            _direction = rand()%4;
            update(screen);

        }


    }

}

//Accessor method uses the ghost's current x and y coordinates and direction returning the value of the
//next screen array position dependent on its direction of movement -returning 0 if the position is empty
//1 is the position if occupied a grid character pixel and 2 or 3 - if the postion is occupied by
//a fruit character pixel
int Ghost::checkCollision(ScreenArray &screen)
{
    int value = 0;
    if(_direction == 1   ) {
        value = screen.get(_x + _size + 1,_y);
    }
    if(_direction == 0 ) {
        value = screen.get(_x,_y - _size - 1);
    }

    if(_direction == 2 ) {
        value = screen.get(_x - _size - 1,_y);
    }

    if(_direction == 3 ) {
        value = screen.get(_x,_y + _size + 1);
    }



    return value;
}