#ifndef CHARACTERSPRITES_H
#define CHARACTERSPRITES_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


/** Charactersprites Class
@author Mr Nigel TK Vere, University of Leeds
@brief Controls and models the fruit characters used in the game main character for the badman game
@date April 2019
*/

/** Charactersprites Class

@brief Controls and models the fruit characters used in the game main character for the badman game

@version 1.0

@author Mr Nigel TK Vere

@date April 2019


*/
class Charactersprites
{

public:
    /**
    * @brief Default Charactersprite object constructor

    */
    Charactersprites();
    /**
    * @brief Default Charactersprite object destructor

    */
    ~Charactersprites();

    /**
    * @brief Mutator method displays the charactersprite object on the lcd screen dependent on it's current x and y coordinates and the respective object type
    * @param lcd @details Refrence NOKIA 5110 LCD screen object
    */
    void displaySprite(N5110 &lcd);
    /**
    * @brief Mutator method initialises the charactersprite  object setting it's top left corner x and y coordinates and the type of object to be drawn
    * @param x @details Integer value representing the value of the x coordinate of the top left corner of the charactersprite object on the screen
    * @param y @details Integer value representing the value of the y coordinate of the top left corner of the charactersprite object on the screen
    * @param num @details Integer value representing the specific charactersprite object to be initialised and drawn subsequently on the screen
    */
    void init(int x,int y,int num);
    /**
    * @brief Accessor method gets the type value of the  charactersrpite object
    @returns Returns the type(_value private variable ) of the  charactersprite object

    */
    int getValue();
    /**
    * @brief Accessor method gets the  coordinates of the top right corner of charactersrpite object
    @returns Returns the top right hand coordinates(_topr private variable ) of the  charactersprite object as a Vector2D object

    */
    Vector2D getTopr();
    /**
    * @brief Accessor method gets the  coordinates of the bottom right corner of charactersrpite object
    @returns Returns the bottom right hand corner coordinates(_bottr private variable ) of the  charactersprite object as a Vector2D object

    */
    Vector2D getBottr();
    /**
    * @brief Accessor method gets the  coordinates of the bottom left corner of charactersrpite object
    @returns Returns the bottom left hand coordinates(_bottl private variable ) of the  charactersprite object as a Vector2D object

    */
    Vector2D getBottl();
    /**
    * @brief Accessor method gets the  coordinates of the top left corner of charactersrpite object
    @returns Returns the top left hand corner coordinates(_topl private variable ) of the  charactersprite object as a Vector2D object

    */
    Vector2D getTopl();







private:
    int _rows;//Integer variable holds the number of rows present in the respective charactersprite object
    int _cols;//Integer variable holds the number of columns present in the respective charactersprite object
    int _type;//Integer variable holds the type of charactersprite object
    int _value;//Integer variable holds the numeric score value of the respective chractersprite
    Vector2D _topr;//Vector variable holds the coordinates of the top right hand corner of the charactersprite object
    Vector2D _bottr;//Vector variable holds the coordinates of the bottom right hand corner of the charactersprite object
    Vector2D _bottl;//Vector variable holds the coordinates of the bottom left hand corner of the charactersprite object
    Vector2D _topl;//Vector variable holds the coordinates of the top left hand corner of the charactersprite object


};
#endif