#ifndef BADMAN_H
#define BADMAN_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


/** Badman Class
@author Mr Nigel TK Vere, University of Leeds
@brief Controls and models the badman main character for the badman game
@date April 2019
*/

/** Badman Class

@brief Controls and models the badman main character for the badman game

@version 1.0

@author Mr Nigel TK Vere

@date April 2019


*/
class Badman
{

public:

    /**
    * @brief Default Badman object constructor

    */
    Badman();
    /**
    * @brief Default Badman object destructor

    */
    ~Badman();
    /**
    * @brief Mutator method initialises the badman character object setting it's radius and start position in the maze
    * @param size @details Integer value giving the radius of our badman character object
    */
    void init(int size);
    /**
    * @brief Mutator method gets displays the badman character on the lcd screen dependent on it's current x and y coordinates and size
    * @param lcd @details Refrence NOKIA 5110 LCD screen object
    */
    void draw(N5110 &lcd);
    /**
    * @brief Accessor method gets the current coordinates of the badman character object
    @returns Returns the Vector data type holding the  current x and y coordinates of the badman character object's centre

    */
    Vector2D getPos();
    /**
    * @brief Mutator method gets the current x and y coordinate of the badman object to the coordinate passed in the function call
    * @param x @details X coordinate value of the new position the badman character object is to move to
    * @param y @details Y coordinate value of the new position the badman character object is to move to

    */

    void setPos(int x, int y);
    /**
    * @brief Accessor method gets the size of badman character object
    @returns Returns the size(radius ) of the badman character object

    */
    int getSize();

private:

    int _x;//Integer value representing the x coordinate of the centre of the badman object
    int _y;//Integer value representing the y coordinate of the centre of the badman object
    int _size;//Integer value representing the radius of the badman character object
};
#endif