#ifndef BADENGINE_H
#define BADENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Badman.h"
#include "Grid.h"
#include "ScreenArray.h"



/** Badengine Class
@author Mr Nigel TK Vere, University of Leeds
@brief Badengine controls the operation of the game per level using the charactersprites,grid,ghost and badman classes
@date April 2019
*/

/** Badengine Class

@brief Badengine controls the operation of the game per level using the charactersprites,grid,ghost and badman classes

@version 1.0

@author Mr Nigel TK Vere

@date April 2019


*/
class Badengine
{

public:
    /**
    * @brief Default Badengine object constructor

    */
    Badengine();
    /**
    * @brief Default Badengine object destructor

    */
    ~Badengine();
    /**
      * @brief Mutator method initialises the badengine  object by initialising the respective charactersprites,grid,ghost and badman classes used in the game

      */
    void init();
    /**
    * @brief Mutator method records the users interactions with the badman character based on the joystick movement

    */
    void readInput(Gamepad &pad);
    /**
    * @brief Mutator method sets the number of ghosts being used at the respective point in time within the game
    * @param number @details Integer value representing the number of ghosts that will appear within the game
    */
    void setGhostNumber(int number);
    /**
    * @brief Mutator method updates the game accordingly depending on the users choice of movement
    * @param pad @details Refrence Gamepad object
    */
    void update(Gamepad &pad);
    /**
    * @brief Mutator method  displays the entire game  on the lcd screen
    * @param lcd @details Refrence NOKIA 5110 LCD screen object
    */
    void draw(N5110 &lcd);
    /* @brief Accessor method gets the status of the game in the case that all the fruit have been eaten by badman in the respective level
    @returns Returns the status(_status private variable  ) value of the badengine object

    */
    bool getStatus();
    /* @brief Accessor method gets the status of the game in terms of whether a collision between badman and a ghost has occured
    @returns Returns the ghost collision status(_ghoststatus private variable ) value of the badengine  object

    */
    bool getGhostStatus();
    
    /* @brief Accessor method gets the current score of the instance of the badengine currently running
    @returns Returns the score(_score private variable ) value of the badengine  object

    */
    int getScore();





private:
    bool _status;//This boolean variable is used to denote whether the badman character has eaten all the fruit in the maze-true if no and false if yes
    bool _ghoststatus;//This boolean variable is used to denote whether any badman-ghost collisions have taken place-true if none and false if one has occured
    int _score;//The integer variable holds the total score for the current game inclusive of all level scores up to the point in time
    int checkCollision();//The check_collison accessor method returns the value of the next position in the grid's screen array value depending on badman's direction of movement at that point in time
    int ghostnumber;//The integer variable holds the number of ghosts being used at this respective call of the badengine object level
    Badman _baddest;//The badman object used in the game for gameplay
    Grid _grid;//The grid object used in the game to generate the maze
    ScreenArray _screen; //The screen array object used for collision detection
    Direction _d;//The direction variable that holds the direction that the badman object is moving towards dependent on the joysticks postion

};

#endif