#include "Badengine.h"

//Badengine default constructor used for object creation
Badengine::Badengine(){
}

//Badengine default destructor used for object destruction
Badengine::~Badengine(){
}

//Mutator method takes an integer number as it's parameter and sets the number of
//ghosts for the respective level in the game denoted by the private variable
//ghost number to this value
void Badengine::setGhostNumber(int number){
    ghostnumber = number;
}

//Mutator method initialises the bad engine object by setting the game's status
//variable to true(denoted that the player has not eaten all the fruit in the maze
//yet) ,setting the ghoststatus private variable to true(denoting that no ghost-badman
// character collisions have taken place yet),the score private variable is initialised to
//zero as at the start no fruit have been eaten,the badman character is initialised with its
//size set to the value passed in the call,the screen array object in use in the game is initialised
//which entails filling the screen array with zeros,the grid object is then initialised with the parameters passed
//being the screen array object and maximum number of ghosts that can be seen in the game which limits the level
//for practicality sake and in consideration of processing power this value is 10
void Badengine::init() {
    _status = true;
    _ghoststatus = true;
    _score = 0;
    _baddest.init(2);
    _screen.init();
    _grid.init(_screen,10);

}

//Mutator method reads the current position that the joystick is in at the point of
//function call setting the private _d variable to this direction datatype value
void Badengine::readInput(Gamepad &pad) {
    _d = pad.get_direction();
}

//Mutator method takes as input a reference to the LCD object subsequently calling the draw
//methods of the grid and badman classes to display to the user the maze,fruits,ghosts and
//badman character at their respective postions dependent on the point of call of this
//method
void Badengine::draw(N5110 &lcd) {
    _grid.drawGrid(lcd,ghostnumber);
    _baddest.draw(lcd);

}

//Mutator method which takes an input a reference gamepad object as the input parameter inorder to
//actuate with the speaker component on the boar.The methods works by updating respective
//flags within the game using methods from different classes inorder to control the
//gameplay
void Badengine::update(Gamepad &pad) {
    //In the event that the badman character controlled by the user has eaten
    //all the fruit in the maze which signals that the level is complete
    //the status flag is set to fault denoting that badman has eaten all the fruit
    if(_grid.getFruitNumber()== 0) {
        _status = false;
    }

    //The below line of code uses the direction set in the preceding call to the
    //read_input method in this instance east moving the badman character once
    //place to the east as long as the character has not collided with a wall within the
    //maze known by the call of the checkCollision()-collision detection method
    if(_d == E && checkCollision() == 0 ) {
        _baddest.setPos(_baddest.getPos().x + 1,_baddest.getPos().y);
    }


    //The below line of code uses the direction set in the preceding call to the value
    //returned by the preceding read_input call and in the event that the badman character has collided with
    //a fruit(eaten a fruit) - takes the coordinates of the collision,and removes the fruit from
    //the grid,updating the score by the value of the fruit collided with,playing a tone
    //in the process to notify to te gamer this collision
    if(_d == E && checkCollision() > 1) {
        _score = _score + checkCollision();
        pad.tone(750.0,0.1);
        _grid.updateFruit(_baddest.getPos().x + _baddest.getSize() + 1,_baddest.getPos().y,_screen);
    }

    //The below line of code uses the direction set in the preceding call to the
    //read_input method in this instance north moving the badman character once
    //place to the north as long as the character has not collided with a wall within the
    //maze known by the call of the checkCollision()-collision detection method
    if(_d == N && checkCollision() == 0) {
        _baddest.setPos(_baddest.getPos().x,_baddest.getPos().y -1);
    }

    //The below line of code uses the direction set in the preceding call to the value
    //returned by the preceding read_input call and in the event that the badman character has collided with
    //a fruit(eaten a fruit) - takes the coordinates of the collision,and removes the fruit from
    //the grid,updating the score by the value of the fruit collided with,playing a tone
    //in the process to notify to te gamer this collision
    if(_d == N && checkCollision() > 1) {
        _score = _score + checkCollision();
        pad.tone(750.0,0.1);
        _grid.updateFruit(_baddest.getPos().x,_baddest.getPos().y - _baddest.getSize() - 1,_screen);
    }

    //The below line of code uses the direction set in the preceding call to the
    //read_input method in this instance west moving the badman character once
    //place to the west as long as the character has not collided with a wall within the
    //maze known by the call of the checkCollision()-collision detection method
    if(_d == W && checkCollision() == 0) {
        _baddest.setPos(_baddest.getPos().x - 1,_baddest.getPos().y );
    }

    //The below line of code uses the direction set in the preceding call to the value
    //returned by the preceding read_input call and in the event that the badman character has collided with
    //a fruit(eaten a fruit) - takes the coordinates of the collision,and removes the fruit from
    //the grid,updating the score by the value of the fruit collided with,playing a tone
    //in the process to notify to te gamer this collision
    if(_d == W && checkCollision() > 1) {
        _score = _score + checkCollision();
        pad.tone(750.0,0.1);
        _grid.updateFruit(_baddest.getPos().x - _baddest.getSize() - 1,_baddest.getPos().y,_screen);
    }

    //The below line of code uses the direction set in the preceding call to the
    //read_input method in this instance south moving the badman character once
    //place to the south as long as the character has not collided with a wall within the
    //maze known by the call of the checkCollision()-collision detection method
    if(_d == S &&checkCollision() == 0) {
        _baddest.setPos(_baddest.getPos().x,_baddest.getPos().y +1);
    }

    //The below line of code uses the direction set in the preceding call to the value
    //returned by the preceding read_input call and in the event that the badman character has collided with
    //a fruit(eaten a fruit) - takes the coordinates of the collision,and removes the fruit from
    //the grid,updating the score by the value of the fruit collided with,playing a tone
    //in the process to notify to te gamer this collision
    if(_d == S &&checkCollision() > 1) {
        pad.tone(750.0,0.1);
        _score = _score + checkCollision();
        _grid.updateFruit(_baddest.getPos().x,_baddest.getPos().y + _baddest.getSize() + 1,_screen);
    }

    //The below lines of code takes the badman character's current x and y coordinates, the total number
    //of ghosts at the level and the screen array object to check whether any badman-ghost collisions
    //has taken place-setting the ghost collision flag to true in the instance that such a collision
    //has taken place
    if(_grid.update(_screen,ghostnumber,_baddest.getPos().x,_baddest.getPos().y,_baddest.getSize()) == true) {
        _ghoststatus = false;
    }
}

//Accessor method uses badman's current x and y coordinates and direction returning the value of the
//next screen array position dependent on its direction of movement -returning 0 if the position is empty
//1 is the position if occupied a grid character pixel and 2 or 3 - if the postion is occupied by
//a fruit character pixel
int Badengine::checkCollision() {
    int value = 0;
    if(_d == E   ) {
        value = _screen.get(_baddest.getPos().x + _baddest.getSize() + 1,_baddest.getPos().y);
    }
    if(_d == N ) {
        value = _screen.get(_baddest.getPos().x,_baddest.getPos().y - _baddest.getSize() - 1);
    }

    if(_d == W ) {
        value = _screen.get(_baddest.getPos().x - _baddest.getSize() - 1,_baddest.getPos().y);
    }

    if(_d == S ) {
        value = _screen.get(_baddest.getPos().x,_baddest.getPos().y + _baddest.getSize() + 1);
    }

    return value;
}

//The accessor method returns the status private variable value at the time of call
bool Badengine::getStatus(){
    return _status;
}

//The accessor method returns the ghoststatus private variable value at the time of call
bool Badengine::getGhostStatus() {
    return _ghoststatus;
}

//The accessor method returns the current score private variable value at the time of call
int Badengine::getScore() {
    return _score;
}
